import Ember from 'ember';
import d3 from 'd3';
import env from 'app-client/config/environment';



export default Ember.Component.extend({

    constants: Ember.inject.service(),

    init: function() {
        this._super(...arguments);
    },

    didRender: function() {
        var self = this;
        var baseURL = env.baseURL.replace(/\/$/,"")+'/api/v1';

        d3.json(baseURL + "/discourses", function(discourses) {

            var width = self.$().parent().width();
            var height = self.$().parent().height();

            var bubble = d3.layout.pack()
                .sort(function comparator(a, b) { return a.value + b.value; })
                .size([width, height])
                .padding(250);

            var element = d3.select('#' + self.get('elementId'))
                .style("position", "relative");

            var bubbles = bubble.nodes(self.createNodes(discourses));

            var caption = element.append("div")
                .style("position", "absolute")
                .style("transform-origin", "50% 50% 0px")
                .attr("class", "caption");

            var caption_nodes = caption.selectAll(".node")
                .data(bubbles);

            caption_nodes.enter().append("div")
                .attr("class", function(d) { return d.children ? " category": " item"; });

            var item = caption.selectAll(".item")
                .style("width", function(d) { return Math.max(10 + d.r, d.r) * 2 + 'px'; })
                .style("height", function(d) { return Math.max(10 + d.r, d.r) * 2 + 'px'; })
                .style("position", "absolute")
                .style("left", function(d) { return d.x - Math.max(10 + d.r, d.r) + 'px'; })
                .style("top", function(d) { return d.y - Math.max(10 + d.r, d.r) + 'px'; })
                .on('click', function(d) { document.location = self.setQueryString('discours', d.name); });
            
            item.append("span")
                .text(function(d) { return d.name; })
                .style("text-align", "center")
                .style("display", function(d) { return d.children ? 'none' : 'inline-block'; })
                .style("width", function() { return $(this).parent().width() > $(this).width() ? $(this).parent().width() + 'px' : ''; })
                .style("text-transform", "capitalize")
                .style("font-size", "15px")
                .style("margin-left", function() { return ( $(this).width() > $(this).parent().width() ? - ( $(this).width() / 2 ) + ( $(this).parent().width() / 2 ) : 0 ) + 'px'; })
                .style("margin-top", function() { return $(this).parent().height() / 2 - $(this).height() / 2 + 'px'; });

            var svg = element.append("svg")
                .style("width", width + "px")
                .style("height", width + "px")
                .attr("class", "bubble");

            var svg_nodes = svg.selectAll(".node")
                .data(bubbles);

            svg_nodes.enter().append("g")
                .attr("class", function(d) { return "node" + (!d.children ? " leaf" : ""); })
                .attr("transform", function(d) { return "translate(" + d.x + "," + d.y + ")"; });

            var leaf = svg.selectAll(".leaf")
                .on('click', function(d) { document.location = self.setQueryString('discours', d.name); });
            
            leaf.append("circle")
                .attr("r", function(d) { return Math.max(7.5 + d.r * 2, d.r * 2); })
                .attr("fill", function(d) { return d.fill; })
                .attr("stroke", function() { return "#000"; });

            element.style("height", height + "px");
        });

        this._super(...arguments);
    },

    createNodes: function(json) {
        var self = this;
        var nodes = {};
        var children = {};

        Object.keys(json).forEach(function(key) {
            var discourse = json[key];
            var index = self.get('constants').DISCOURSES[key];
            var category = self.get('constants').DISCOURSE_CATEGORIES[index];

            children[index] = children[index] || {};
            children[index]['name'] = index;
            children[index]['children'] = children[index]['children'] || [];
            children[index]['children'].push({ "name": discourse.label, "value": discourse.count, "fill": category.fill });
        });

        nodes.children = [];
        Object.keys(children).forEach(function(key) {
            nodes.children.push(children[key]);
        });

        return nodes;
    },

    setQueryString: function(field, value) {
        var hash = document.location.href.split('?');
        var query_parameters = hash.length > 1 ? hash.pop() : '';

        // Unserialize
        var parameters = [];
        query_parameters.split('&').forEach(function(parameter){
            var object = parameter.split('=');
            if(object[1]) {
                parameters[object[0]] = object[1];
            }
        });

        // Serialize
        var string = [];
        parameters[field] = encodeURI(value);
        Object.keys(parameters).forEach(function(key) {
            string.push(key + '=' + parameters[key]);
        });

        return hash + '?' + string.join('&');
    }
    
});
