<?php

use CorpusParole\Models\TranscriptResource;
use CorpusParole\Libraries\CocoonUtils;

/**
 *
 */
class TranscriptResourceTest extends TestCase {

    const TEST_DOCS = [
        'http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml' => <<<EOT
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix sesame: <http://www.openrdf.org/schema/sesame#> .
    @prefix owl: <http://www.w3.org/2002/07/owl#> .
    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
    @prefix fn: <http://www.w3.org/2005/xpath-functions#> .

    <http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml> a <http://www.europeana.eu/schemas/edm/WebResource> ;
        <http://purl.org/dc/elements/1.1/format> "application/xml"^^<http://purl.org/dc/terms/IMT> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/issued> "2013-11-04T22:20:07+01:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
        <http://purl.org/dc/terms/conformsTo> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_transcriber> .

EOT
    ,'http://cocoon.huma-num.fr/data/archi/masters/372593.wav' => <<<EOT
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix sesame: <http://www.openrdf.org/schema/sesame#> .
    @prefix owl: <http://www.w3.org/2002/07/owl#> .
    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
    @prefix fn: <http://www.w3.org/2005/xpath-functions#> .

    <http://cocoon.huma-num.fr/data/archi/masters/372593.wav> a <http://www.europeana.eu/schemas/edm/WebResource> ;
        <http://purl.org/dc/elements/1.1/format> "audio/x-wav"^^<http://purl.org/dc/terms/IMT> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/extent> "PT48M26S" ;
        <http://purl.org/dc/terms/issued> "2013-10-12T14:35:57+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> .
EOT
    ];

    public function setUp() {

        parent::setup();
        $this->graphs = [];
        foreach(self::TEST_DOCS as $uri => $ttl) {
            $this->graphs[$uri] = new EasyRdf\Graph($uri, $ttl);
        }
    }

    public function testConstructor() {

        $this->assertNotNull($this->graphs, 'Graphs shoud not be null');

        $transcriptResource = new TranscriptResource('http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml', $this->graphs['http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml']);

        $this->assertNotNull($transcriptResource);
    }

    public function testConformsTo() {
        $transcriptResource = new TranscriptResource('http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml', $this->graphs['http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml']);
        $this->assertEquals('http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_transcriber', $transcriptResource->getConformsTo());
    }

    public function testJsonSerialize() {
        $transcriptResource = new TranscriptResource('http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml', $this->graphs['http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml']);

        $json = $transcriptResource->jsonSerialize();
        $this->assertTrue(is_array($json), "must be an array");
        $this->assertEquals(
            [
                'url' => "http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml",
                "format" => "application/xml",
                "conforms-to" => "http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_transcriber"
            ],
            $json
        );
    }

}
