<?php
namespace CorpusParole\Models;

use EasyRdf\Resource;

/**
 */
class WebResourceManager {

    public static function getResource(...$args) {

        list($url,$graph) = $args;
        $webResource = new Resource($url, $graph);
        $formatLit = $webResource->getLiteral("dc11:format");
        $format = is_null($formatLit)?null:$formatLit->getValue();
        if(is_null($format)) {
            throw new ModelsException("WebResourceManager: No dc:11 format on web resource");
        }

        if(0 === strpos($format, 'audio/') ||
           0 === strpos($format, 'video/') ||
           0 === strpos($format, 'Sampling:') ) {
            return new MediaResource(...$args);
        } else if(
            0 === strpos($format, 'application/xml') ||
            0 === strpos($format, 'application/pdf') ) {
            return new TranscriptResource(...$args);
        }
        else {
            throw new ModelsException("WebResourceManager: unknown format");
        }

    }

}