<?php

use Mockery as m;

use EasyRdf\Resource;
use EasyRdf\Literal;

/**
 *
 */
class ThemeControllerTest extends TestCase {

    public function setUp() {

        parent::setup();

    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndex() {

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'query' =>[
                    'match_all' => []
                ],
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => config('corpusparole.theme_default_limit'),
                                    "order" => [ '_count' => 'desc' ],
                                    "include" => ".*\|bnf\|.*"
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        Es::shouldReceive('search')
            ->once()
            ->with($query)
            ->andReturn([
                "took" => 27,
                "timed_out" => false,
                "_shards" => [
                    "total" => 1,
                    "successful" => 1,
                    "failed" => 0
                ],
                "hits" => [
                    "total" => 3011,
                    "max_score" => 0.0,
                    "hits" => [ ]
                ],
                "aggregations" => [
                    "subjects" => [
                        "doc_count" => 41524,
                        "subjects" => [
                            "doc_count_error_upper_bound" => 0,
                            "sum_other_doc_count" => 13678,
                            "buckets" => [ [
                                "key" => "professions|bnf|ark:/12148/cb13318415c",
                                "doc_count" => 1412
                            ], [
                                "key" => "travail non rémunéré|bnf|ark:/12148/cb16604691s",
                                "doc_count" => 1092
                            ], [
                                "key" => "famille|bnf|ark:/12148/cb119339867",
                                "doc_count" => 1050
                            ], [
                                "key" => "oiseaux|bnf|ark:/12148/cb11932889r",
                                "doc_count" => 1003
                            ], [
                                "key" => "météorologie|bnf|ark:/12148/cb11932496x",
                                "doc_count" => 1001
                            ], [
                                "key" => "plantes|bnf|ark:/12148/cb11933145f",
                                "doc_count" => 995
                            ], [
                                "key" => "animaux sauvages|bnf|ark:/12148/cb11930908q",
                                "doc_count" => 989
                            ], [
                                "key" => "arbres|bnf|ark:/12148/cb11934786x",
                                "doc_count" => 989
                            ] ]
                        ]
                    ]
                ]
            ]);
        $this->get('/api/v1/stats/themes/')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["themes" => [
            "http://ark.bnf.fr/ark:/12148/cb13318415c" => ['label' => 'professions', 'count' => 1412 ],
            "http://ark.bnf.fr/ark:/12148/cb16604691s" => ['label' => 'travail non rémunéré', 'count' => 1092 ],
            "http://ark.bnf.fr/ark:/12148/cb119339867" => ['label' => 'famille', 'count' => 1050 ],
            "http://ark.bnf.fr/ark:/12148/cb11932889r" => ['label' => 'oiseaux', 'count' => 1003 ],
            "http://ark.bnf.fr/ark:/12148/cb11932496x" => ['label' => 'météorologie', 'count' => 1001 ],
            "http://ark.bnf.fr/ark:/12148/cb11933145f" => ['label' => 'plantes', 'count' => 995  ],
            "http://ark.bnf.fr/ark:/12148/cb11930908q" => ['label' => 'animaux sauvages', 'count' => 989 ],
            "http://ark.bnf.fr/ark:/12148/cb11934786x" => ['label' => 'arbres', 'count' => 989 ]
        ]]);

    }

    public function testIndexAll() {

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'query' =>[
                    'match_all' => []
                ],
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => config('corpusparole.theme_default_limit'),
                                    "order" => [ '_count' => 'desc' ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        Es::shouldReceive('search')
            ->once()
            ->with($query)
            ->andReturn([
                "took" => 27,
                "timed_out" => false,
                "_shards" => [
                    "total" => 1,
                    "successful" => 1,
                    "failed" => 0
                ],
                "hits" => [
                    "total" => 3011,
                    "max_score" => 0.0,
                    "hits" => [ ]
                ],
                "aggregations" => [
                    "subjects" => [
                        "doc_count" => 41524,
                        "subjects" => [
                            "doc_count_error_upper_bound" => 0,
                            "sum_other_doc_count" => 13678,
                            "buckets" => [ [
                                "key" => "professions|bnf|ark:/12148/cb13318415c",
                                "doc_count" => 1412
                            ], [
                                "key" => "travail non rémunéré|bnf|ark:/12148/cb16604691s",
                                "doc_count" => 1092
                            ], [
                                "key" => "famille|bnf|ark:/12148/cb119339867",
                                "doc_count" => 1050
                            ], [
                                "key" => "oiseaux|bnf|ark:/12148/cb11932889r",
                                "doc_count" => 1003
                            ], [
                                "key" => "Français|lxv|fra",
                                "doc_count" => 1002
                            ], [
                                "key" => "météorologie|bnf|ark:/12148/cb11932496x",
                                "doc_count" => 1001
                            ], [
                                "key" => "plantes|bnf|ark:/12148/cb11933145f",
                                "doc_count" => 995
                            ], [
                                "key" => "Breton|lxv|bzh",
                                "doc_count" => 992
                            ], [
                                "key" => "animaux sauvages|bnf|ark:/12148/cb11930908q",
                                "doc_count" => 989
                            ], [
                                "key" => "arbres|bnf|ark:/12148/cb11934786x",
                                "doc_count" => 989
                            ] ]
                        ]
                    ]
                ]
            ]);
        $this->get('/api/v1/stats/themes/?filter=all')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["themes" => [
            "http://ark.bnf.fr/ark:/12148/cb13318415c" => ['label' => 'professions', 'count' => 1412 ],
            "http://ark.bnf.fr/ark:/12148/cb16604691s" => ['label' => 'travail non rémunéré', 'count' => 1092 ],
            "http://ark.bnf.fr/ark:/12148/cb119339867" => ['label' => 'famille', 'count' => 1050 ],
            "http://ark.bnf.fr/ark:/12148/cb11932889r" => ['label' => 'oiseaux', 'count' => 1003 ],
            "http://lexvo.org/id/iso639-3/fra" => ['label' => 'Français', 'count' => 1002 ],
            "http://ark.bnf.fr/ark:/12148/cb11932496x" => ['label' => 'météorologie', 'count' => 1001 ],
            "http://ark.bnf.fr/ark:/12148/cb11933145f" => ['label' => 'plantes', 'count' => 995  ],
            "http://lexvo.org/id/iso639-3/bzh" => ['label' => 'Breton', 'count' => 992 ],
            "http://ark.bnf.fr/ark:/12148/cb11930908q" => ['label' => 'animaux sauvages', 'count' => 989 ],
            "http://ark.bnf.fr/ark:/12148/cb11934786x" => ['label' => 'arbres', 'count' => 989 ]
        ]]);

    }

    public function testIndexLexvo() {

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'query' =>[
                    'match_all' => []
                ],
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => config('corpusparole.theme_default_limit'),
                                    "order" => [ '_count' => 'desc' ],
                                    "include" => ".*\|lxv\|.*"
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        Es::shouldReceive('search')
            ->once()
            ->with($query)
            ->andReturn([
                "took" => 27,
                "timed_out" => false,
                "_shards" => [
                    "total" => 1,
                    "successful" => 1,
                    "failed" => 0
                ],
                "hits" => [
                    "total" => 3011,
                    "max_score" => 0.0,
                    "hits" => [ ]
                ],
                "aggregations" => [
                    "subjects" => [
                        "doc_count" => 41524,
                        "subjects" => [
                            "doc_count_error_upper_bound" => 0,
                            "sum_other_doc_count" => 13678,
                            "buckets" => [ [
                                "key" => "Français|lxv|fra",
                                "doc_count" => 1002
                            ], [
                                "key" => "Breton|lxv|bzh",
                                "doc_count" => 992
                            ] ]
                        ]
                    ]
                ]
            ]);
        $this->get('/api/v1/stats/themes/?filter=lexvo')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["themes" => [
            "http://lexvo.org/id/iso639-3/fra" => ['label' => 'Français', 'count' => 1002 ],
            "http://lexvo.org/id/iso639-3/bzh" => ['label' => 'Breton', 'count' => 992 ]
        ]]);

    }

    private function getOrderQuery($order) {
        return [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'query' =>[
                    'match_all' => []
                ],
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => config('corpusparole.theme_default_limit'),
                                    "order" => $order,
                                    "include" => ".*\|bnf\|.*"
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

    }

    private function getRespSort() {
        return [
            "took" => 27,
            "timed_out" => false,
            "_shards" => [
                "total" => 1,
                "successful" => 1,
                "failed" => 0
            ],
            "hits" => [
                "total" => 3011,
                "max_score" => 0.0,
                "hits" => [ ]
            ],
            "aggregations" => [
                "subjects" => [
                    "doc_count" => 41524,
                    "subjects" => [
                        "doc_count_error_upper_bound" => 0,
                        "sum_other_doc_count" => 13678,
                        "buckets" => [  ]
                    ]
                ]
            ]
        ];
    }

    public function testIndexSort() {

        Es::shouldReceive('search')
            ->once()
            ->with($this->getOrderQuery(['_count' => 'desc']))
            ->andReturn($this->getRespSort());
        $this->get('/api/v1/stats/themes/')->assertTrue($this->response->isOk(), $this->response->content());

    }

    public function testIndexSortReverseCount() {
        Es::shouldReceive('search')
            ->once()
            ->with($this->getOrderQuery(['_count' => 'asc']))
            ->andReturn($this->getRespSort());
        $this->get('/api/v1/stats/themes/?sort=-count')->assertTrue($this->response->isOk(), $this->response->content());
    }

    public function testIndexSortLabel() {
        Es::shouldReceive('search')
            ->once()
            ->with($this->getOrderQuery(['_term' => 'asc']))
            ->andReturn($this->getRespSort());
        $this->get('/api/v1/stats/themes/?sort=label')->assertTrue($this->response->isOk(), $this->response->content());
    }

    public function testIndexSortAlphabetical() {
        Es::shouldReceive('search')
            ->once()
            ->with($this->getOrderQuery(['_term' => 'asc']))
            ->andReturn($this->getRespSort());
        $this->get('/api/v1/stats/themes/?sort=alphabetical')->assertTrue($this->response->isOk(), $this->response->content());
    }

    public function testIndexSortLabelReverse() {
        Es::shouldReceive('search')
            ->once()
            ->with($this->getOrderQuery(['_term' => 'desc']))
            ->andReturn($this->getRespSort());
        $this->get('/api/v1/stats/themes/?sort=-label')->assertTrue($this->response->isOk(), $this->response->content());
    }


    public function testIndexLimit() {

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'query' =>[
                    'match_all' => []
                ],
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => 3,
                                    "order" => [ '_count' => 'desc' ],
                                    "include" => ".*\|bnf\|.*"
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        // This is not normally what should be received, but we test that the limit is respected
        Es::shouldReceive('search')
            ->once()
            ->with($query)
            ->andReturn([
                "took" => 27,
                "timed_out" => false,
                "_shards" => [
                    "total" => 1,
                    "successful" => 1,
                    "failed" => 0
                ],
                "hits" => [
                    "total" => 3011,
                    "max_score" => 0.0,
                    "hits" => [ ]
                ],
                "aggregations" => [
                    "subjects" => [
                        "doc_count" => 41524,
                        "subjects" => [
                            "doc_count_error_upper_bound" => 0,
                            "sum_other_doc_count" => 13678,
                            "buckets" => [ [
                                "key" => "professions|bnf|ark:/12148/cb13318415c",
                                "doc_count" => 1412
                            ], [
                                "key" => "travail non rémunéré|bnf|ark:/12148/cb16604691s",
                                "doc_count" => 1092
                            ], [
                                "key" => "famille|bnf|ark:/12148/cb119339867",
                                "doc_count" => 1050
                            ], [
                                "key" => "oiseaux|bnf|ark:/12148/cb11932889r",
                                "doc_count" => 1003
                            ], [
                                "key" => "météorologie|bnf|ark:/12148/cb11932496x",
                                "doc_count" => 1001
                            ], [
                                "key" => "plantes|bnf|ark:/12148/cb11933145f",
                                "doc_count" => 995
                            ], [
                                "key" => "animaux sauvages|bnf|ark:/12148/cb11930908q",
                                "doc_count" => 989
                            ], [
                                "key" => "arbres|bnf|ark:/12148/cb11934786x",
                                "doc_count" => 989
                            ] ]
                        ]
                    ]
                ]
            ]);
        $this->get('/api/v1/stats/themes/?limit=3')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["themes" => [
            "http://ark.bnf.fr/ark:/12148/cb13318415c" => ['label' => 'professions', 'count' => 1412 ],
            "http://ark.bnf.fr/ark:/12148/cb16604691s" => ['label' => 'travail non rémunéré', 'count' => 1092 ],
            "http://ark.bnf.fr/ark:/12148/cb119339867" => ['label' => 'famille', 'count' => 1050 ]
        ]]);

    }

    public function testIndexIndex() {

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'query' =>[
                    'match_all' => []
                ],
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => 6,
                                    "order" => [ '_count' => 'desc' ],
                                    "include" => ".*\|bnf\|.*"
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        // This is not normally what should be received, but we test that the limit is respected
        Es::shouldReceive('search')
            ->once()
            ->with($query)
            ->andReturn([
                "took" => 27,
                "timed_out" => false,
                "_shards" => [
                    "total" => 1,
                    "successful" => 1,
                    "failed" => 0
                ],
                "hits" => [
                    "total" => 3011,
                    "max_score" => 0.0,
                    "hits" => [ ]
                ],
                "aggregations" => [
                    "subjects" => [
                        "doc_count" => 41524,
                        "subjects" => [
                            "doc_count_error_upper_bound" => 0,
                            "sum_other_doc_count" => 13678,
                            "buckets" => [ [
                                "key" => "professions|bnf|ark:/12148/cb13318415c",
                                "doc_count" => 1412
                            ], [
                                "key" => "travail non rémunéré|bnf|ark:/12148/cb16604691s",
                                "doc_count" => 1092
                            ], [
                                "key" => "famille|bnf|ark:/12148/cb119339867",
                                "doc_count" => 1050
                            ], [
                                "key" => "oiseaux|bnf|ark:/12148/cb11932889r",
                                "doc_count" => 1003
                            ], [
                                "key" => "météorologie|bnf|ark:/12148/cb11932496x",
                                "doc_count" => 1001
                            ], [
                                "key" => "plantes|bnf|ark:/12148/cb11933145f",
                                "doc_count" => 995
                            ], [
                                "key" => "animaux sauvages|bnf|ark:/12148/cb11930908q",
                                "doc_count" => 989
                            ], [
                                "key" => "arbres|bnf|ark:/12148/cb11934786x",
                                "doc_count" => 989
                            ] ]
                        ]
                    ]
                ]
            ]);
        $this->get('/api/v1/stats/themes/?limit=3&index=1')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["themes" => [
            "http://ark.bnf.fr/ark:/12148/cb11932889r" => ['label' => 'oiseaux', 'count' => 1003 ],
            "http://ark.bnf.fr/ark:/12148/cb11932496x" => ['label' => 'météorologie', 'count' => 1001 ],
            "http://ark.bnf.fr/ark:/12148/cb11933145f" => ['label' => 'plantes', 'count' => 995  ]
        ]]);

    }

    public function testIndexLimitIndex2() {

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'query' =>[
                    'match_all' => []
                ],
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => 9,
                                    "order" => [ '_count' => 'desc' ],
                                    "include" => ".*\|bnf\|.*"
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        // This is not normally what should be received, but we test that the limit is respected
        Es::shouldReceive('search')
            ->once()
            ->with($query)
            ->andReturn([
                "took" => 27,
                "timed_out" => false,
                "_shards" => [
                    "total" => 1,
                    "successful" => 1,
                    "failed" => 0
                ],
                "hits" => [
                    "total" => 3011,
                    "max_score" => 0.0,
                    "hits" => [ ]
                ],
                "aggregations" => [
                    "subjects" => [
                        "doc_count" => 41524,
                        "subjects" => [
                            "doc_count_error_upper_bound" => 0,
                            "sum_other_doc_count" => 13678,
                            "buckets" => [ [
                                "key" => "professions|bnf|ark:/12148/cb13318415c",
                                "doc_count" => 1412
                            ], [
                                "key" => "travail non rémunéré|bnf|ark:/12148/cb16604691s",
                                "doc_count" => 1092
                            ], [
                                "key" => "famille|bnf|ark:/12148/cb119339867",
                                "doc_count" => 1050
                            ], [
                                "key" => "oiseaux|bnf|ark:/12148/cb11932889r",
                                "doc_count" => 1003
                            ], [
                                "key" => "météorologie|bnf|ark:/12148/cb11932496x",
                                "doc_count" => 1001
                            ], [
                                "key" => "plantes|bnf|ark:/12148/cb11933145f",
                                "doc_count" => 995
                            ], [
                                "key" => "animaux sauvages|bnf|ark:/12148/cb11930908q",
                                "doc_count" => 989
                            ], [
                                "key" => "arbres|bnf|ark:/12148/cb11934786x",
                                "doc_count" => 989
                            ] ]
                        ]
                    ]
                ]
            ]);
        $this->get('/api/v1/stats/themes/?limit=3&index=2')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["themes" => [
            "http://ark.bnf.fr/ark:/12148/cb11930908q" => ['label' => 'animaux sauvages', 'count' => 989 ],
            "http://ark.bnf.fr/ark:/12148/cb11934786x" => ['label' => 'arbres', 'count' => 989 ]
        ]]);
    }

}
