
export const LEXVO_BASE_URL = 'http://lexvo.org/id/iso639-3/';

export const LANGUAGES_NODE_PREFIX = 'corpus-';

export const VIAF_BASE_URL = 'http://viaf.org/viaf/';

export const BNF_BASE_URL = 'http://data.bnf.fr/';

export const BNF_ARK_BASE_URL = 'http://ark.bnf.fr/';
export const BNF_ARK_BASE_ID = 'ark:/12148/';

export const GEONAMES_BASE_URLS = 'https?:\\/\\/(?:www|sws)\\.geonames\\.org/';
export const GEONAMES_BASE_URL = 'http://sws.geonames.org/';

export const CORPUS_DISCOURSE_TYPES = {
  'http://ark.bnf.fr/ark:/12148/cb12083158d': 'argumentation',
  'http://ark.bnf.fr/ark:/12148/cb119783362': 'Bavardage',
  'http://ark.bnf.fr/ark:/12148/cb13319048g': 'chansons',
  'http://ark.bnf.fr/ark:/12148/cb11931724n': 'congrès et conférences',
  'http://ark.bnf.fr/ark:/12148/cb11936159v': 'contes',
  'http://ark.bnf.fr/ark:/12148/cb119317924': 'conversation',
  'http://ark.bnf.fr/ark:/12148/cb12481481z': 'dialogue',
  'http://ark.bnf.fr/ark:/12148/cb11948542x': 'discours',
  'http://ark.bnf.fr/ark:/12148/cb119341539': 'discussion',
  'http://ark.bnf.fr/ark:/12148/cb120502737': 'enquêtes linguistiques',
  'http://ark.bnf.fr/ark:/12148/cb11932135w': 'entretiens',
  'http://ark.bnf.fr/ark:/12148/cb11953414d': 'fables',
  'http://ark.bnf.fr/ark:/12148/cb11955657q': 'lecture à haute voix',
  'http://ark.bnf.fr/ark:/12148/cb11957378b': 'musique instrumentale',
  'http://ark.bnf.fr/ark:/12148/cb11937212q': 'narration',
  'http://ark.bnf.fr/ark:/12148/cb11946100d': 'paradigme (épistémologie)',
  'http://ark.bnf.fr/ark:/12148/cb119829234': 'questionnaires',
  'http://ark.bnf.fr/ark:/12148/cb119834877': 'récitation',
  'http://ark.bnf.fr/ark:/12148/cb11976851v': 'récits personnels',
  'http://ark.bnf.fr/ark:/12148/cb11949715t': 'réunions'
};

export const DEFAULT_STORE_EXP = 3600000;

export const NOID_CHARS = [
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
  'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'm', 'n',
  'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'z'
];
export const NOID_CHARS_POS = {
  '0': 0, '1': 1, '2': 2, '3': 3, '4': 4, '5': 5, '6': 6, '7': 7, '8': 8, '9': 9,
  'b': 10, 'c': 11, 'd': 12, 'f': 13, 'g': 14, 'h': 15, 'j': 16, 'k': 17, 'm': 18, 'n': 19,
  'p': 20, 'q': 21, 'r': 22, 's': 23, 't': 24, 'v': 25, 'w': 26, 'x': 27, 'z': 28
};
