import Ember from 'ember';
import chroma from 'chroma';

export const LINEAR_COLOR_START = "#777777";
export const LINEAR_COLOR_END   = "#333333";

export function shadeLinear(v, vmin, vmax) {
    var s = chroma.scale([LINEAR_COLOR_START, LINEAR_COLOR_END]).mode('lab').domain([vmin,vmax]);
    return s(v).hex();
}

export function shade(v, vmin, vmax) {
    var aColor = chroma(LINEAR_COLOR_START).rgb();
    var aSolidColor = chroma(LINEAR_COLOR_END).rgb();
    var aFillColor = [];
    for(var i = 0; i < 3; i++) {
      aFillColor.push((v - vmin) * (aSolidColor[i] - aColor[i]) / (vmax - vmin) + aColor[i]);
    }
    return chroma.rgb(aFillColor).hex();
}

export function getComplement(c) {
    let chromaColorHsl = chroma(c).hsl();
    console.log(chromaColorHsl[0]);
    chromaColorHsl[0] += 180;
    if (chromaColorHsl[0] > 360) {
        chromaColorHsl[0] -= 360;
    }
    chromaColorHsl[0] /= 360;

    return chroma.hsl(chromaColorHsl).hex();

}

export function getPerceptiveLuminance(c) {
    var rgb = chroma(c).rgb();
    return 1 - ( 0.299 * rgb[0] + 0.587 * rgb[1] + 0.114 * rgb[2])/255;
}

export default Ember.Service.extend({
    shadeLinear: shadeLinear,
    getComplement: getComplement,
    getPerceptiveLuminance: getPerceptiveLuminance,
    LINEAR_COLOR_START: LINEAR_COLOR_START,
    LINEAR_COLOR_END: LINEAR_COLOR_END
});
