import Ember from 'ember';
import _ from 'lodash/lodash';

export default Ember.Component.extend({

    range: [],
    rawdatestats: null,

    decades: Ember.computed('range', function() {
        var range = this.get('range');
        return _.range(Math.floor(range[0]/10)*10, (Math.floor(range[1]/10)+1)*10, 10);
    }),

    datestats: Ember.computed('rawdatestats.[]', function() {
        var res = {};
        this.get('rawdatestats').forEach(function(s) {
            res[s.get('id')] = s.get('count');
        });
        return Ember.Object.create(res);
    }),

    counts: Ember.computed.mapBy('rawdatestats', 'count'),
    maxCount: Ember.computed.max('counts'),
    minCount: Ember.computed.min('counts'),

    filter: Ember.inject.service(),

    date: Ember.computed.alias('filter.dateList'),

    elementId: "chrono-table",

    didInsertElement: function(){

        var self = this;

        var isMouseDown = false,
            isHighlighted,
            didHighlight,
            previousElement;

        Ember.$("#chrono-table li").mousedown(function (event) {
            // Prevent right click selection.
            if(event.button === 0) {

                isMouseDown = true;
                var element = parseInt(Ember.$(this).attr('id'));
                if(!_.inRange(element, self.get('range')[0], self.get('range')[1]+1)) {
                    return false;
                }
                var elements = [element];
                if(event.shiftKey) {
                    while(previousElement !== element) {
                        elements.push(previousElement);
                        if(previousElement < element) {
                            previousElement = previousElement + 1;
                        } else if(previousElement > element) {
                            previousElement = previousElement - 1;
                        } else {
                            break;
                        }
                    }
                }
                var dates = self.get('date');
                var index = dates.indexOf(element);
                if((!event.shiftKey && index === -1) || (event.shiftKey && didHighlight)) {
                    dates = dates.concat(elements);
                    isHighlighted = true;
                } else {
                    elements.forEach(function(el) {
                        var id = dates.indexOf(el);
                        if((!event.shiftKey && index !== -1) || (event.shiftKey && id !== -1)) {
                            dates.splice(id, 1);
                        }
                    });
                    isHighlighted = false;
                }
                self.set('date', dates);
                didHighlight = isHighlighted;
                previousElement = element;
                // Prevent text selection.
                return false;
            }
        }).mouseover(function () {
            if (isMouseDown) {
                var element = parseInt(Ember.$(this).attr('id'));
                if(Ember.$(this).hasClass("highlighted") !== isHighlighted) {
                    var dates = self.get('date');
                    var index = dates.indexOf(element);
                    if(index === -1) {
                        dates.push(element);
                    } else {
                        dates.splice(index, 1);
                    }
                    self.set('date', dates);
                }
                previousElement = element;
            }
        }).bind("selectstart", function () {
            return false;
        });

        Ember.$(document).mouseup(function () {
            isMouseDown = false;
        });
    },

    actions : {

        selectDecade: function(decade) {
            var array = [];
            var next = decade + 10;
            var dates = this.get('date');
            while(decade < next) {
                array.push(decade);
                decade ++;
            }
            if(array.find(function(date){ return dates.indexOf(date) === -1; })) {
                array = array.filter(function(value) {
                    return dates.indexOf(value) === -1;
                });
                array = dates.concat(array);
            } else {
                array = dates.filter(function(value) {
                    return array.indexOf(value) === -1;
                });
            }
            this.set('date', array);
        }

    }

});
