import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['playlist-component'],

    filter: Ember.inject.service(),
    player: Ember.inject.service(),

    model: [],
    documents: Ember.computed('model', 'filter.location', 'filter.language', 'filter.discourse', 'filter.date', 'filter.theme', function() {
        return this.get('model');
    }),

    documentsLoaded: Ember.observer('documents', function() {
        this.get('player').set('items', this.get('documents').map(function(document) {
            return document.get('id');
        }));
        if(this.get('player').get('items').length && this.get('player').get('playing') === false) {
            this.get('player').set('item', this.get('player').get('items')[0]);
        }
    }).on('init'),

    playerItemObserver: Ember.observer('player.item', function() {
        if(this.$() && this.get('player').get('item')) {
            var ul = this.$().find('ul');
            var li = this.$().find('li#' + this.get('player').get('item').replace('.', '\\.').replace('/', '\\/'));
            if(li.length) {
                if(li.offset().top - ul.offset().top < 0) {
                    ul.animate({
                        'scrollTop': ul.scrollTop() + li.offset().top - ul.offset().top
                    });
                } else if(li.offset().top + li.outerHeight() - ul.offset().top > ul.outerHeight()) {
                    ul.animate({
                        'scrollTop': ul.scrollTop() + li.offset().top  + li.outerHeight() - ul.offset().top  - ul.height()
                    });
                }
            }
        }
    }),

    didRender: function() {
        this._super(...arguments);
        this.$().find('ul').height(Ember.$('.corpus-app-wrapper').outerHeight() - (Ember.$('.filter-component').outerHeight() + this.$().find('h2').outerHeight()));
    },

    actions: {

        previous: function() {
            this.sendAction('pageAction', 'previous');
        },

        next: function() {
            this.sendAction('pageAction', 'next');
        },

        select: function(id) {
            this.get('player').select(id);
            this.get('player').displayMetadata('notice');
        },

        play: function(id) {
            this.get('player').play(id);
        },

        pause: function() {
            this.get('player').pause();
        },

        displayTranscript: function() {
            this.get('player').displayAdditionalInformation('transcript');
        },

        displayNotice: function() {
            if(this.get('player').get('window') !== 'notice') {
                this.get('player').displayMetadata('notice');
            } else {
                this.get('player').displayMetadata(false);
            }
        }

    }

});
