import Ember from 'ember';
import _ from 'lodash/lodash';

export default Ember.Controller.extend({

    player: Ember.inject.service(),
    filter: Ember.inject.service(),
    constants: Ember.inject.service(),

    page: 1,
    limit: Ember.computed(function() {
      return this.get('constants').DOCUMENTS_PAGINATION_PERPAGE;
    }),

    playerVideoscreenObserver: Ember.observer('player.videoscreen', function() {
        Ember.$('body').toggleClass('videoscreen', this.get('player').get('videoscreen'));
    }),

    queryParams : Ember.computed('filter.queryParams', function() {
        var res = _.clone(this.get('filter').get('queryParams'));
        res.push('notice');
        res.push('page');
        return res;
    }),

    // this has to be done because queryParameters can not be computed properties...
    // Of course, we rather had computed properties.
    // c.f. : https://github.com/emberjs/ember.js/issues/11592
    date: null,
    discourse: null,
    language: null,
    location: null,
    theme: null,

    languageObserver: Ember.observer('language', 'date', 'date.[]', 'discourse', 'discourse.[]', 'location', 'theme', 'theme.[]', function() {
        this.get('filter').setProperties(this.getProperties('language', 'date', 'discourse', 'theme', 'location'));
    }),
    filterObserver: Ember.observer('filter', 'filter.language', 'filter.date', 'filter.date.[]', 'filter.discourse', 'filter.discourse.[]', 'filter.location', 'filter.theme', 'filter.theme.[]', function() {
        this.set('language', this.get('filter').get('language'));
        this.setProperties(this.get('filter').getProperties('language', 'date', 'discourse', 'theme', 'location'));
    }),

    itemObserver: Ember.observer('player.item', function() {
        var self = this;
        this.store.findRecord('document', this.get('player').get('item'), { reload: true }).then(function(model){
            self.get('player').set('model', model);
            if (self.get('player').get('model').get('transcript')) {
                self.store.findRecord('transcript', self.get('player').get('item')).then(function(model) {
                    self.get('player').set('transcript', model);
                });
            } else {
                self.get('player').set('transcript', null);
            }
        });
    }),

    notice: null,
    noticeModel: null,

    noticeObserver: Ember.observer('notice', function() {
        var self = this;
        if (this.get('notice')) {
            this.store.findRecord('document', this.get('notice'), { reload: true }).then(function(model){
                self.set('noticeModel', model);
            });
        }
    }),
    noticeModelObserver: Ember.observer('noticeModel', function() {
        if (!this.get('noticeModel')) {
            this.set('notice', null);
        }
    }),

    init: function() {
        this._super(...arguments);
        this.get('player');
        this.get('filter');
    },

    actions: {

        setPageQueryparams: function(type) {
            var page = this.get('page');
            if(type === 'previous') {
                page = page - 1;
            } else if(type === 'next') {
                page = page + 1;
            }
            this.propertyWillChange('page');
            this.set('page', page);
            this.propertyDidChange('page');
        },

        play: function(item){
            this.set("currentId", item.id);
        }

    }
});
