<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;
use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Services\GeonamesResolverInterface;
use CorpusParole\Services\GeonamesResolverException;

class GeonamesController extends Controller
{
    public function __construct(GeonamesResolverInterface $geonamesResolver) {
        $this->geonamesResolver = $geonamesResolver;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id od comma separatedlist of ids
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            return response()->json(['geonamesids' => $this->geonamesResolver->getLabels(explode(",", $id))]);
        } catch (GeonamesResolverException $e) {
            abort($e->getCode(), $e->getMessage());
        }
    }

}
