<?php
namespace CorpusParole\Services;

interface BnfResolverInterface {

    /**
     * Get name from Viaf id
     * @param string $id The id to resolve. Can be an url starting with http://data.bnf.fr/ or http://ark.bnf.fr/
     * @return a string with the name
     */
    public function getLabel($id);

    /**
     * Get a list of names from an array of viaf ids.
     * @param array $ids The array of ids to resolve.
     *                   Each id can be an url starting with http://data.bnf.fr/ or http://ark.bnf.fr/
     */
    public function getLabels(array $ids);

}
