/* jshint node:true */
/* eslint-env node */
/* eslint global-require: 0, no-magic-numbers: 0 */

module.exports = function(app) {
  const express = require('express');
  const _ = require('lodash');

  const v1GeonamesRouter = express.Router();

  const geonamesMappings = require('../fixtures/geonames');

  v1GeonamesRouter.get('/:id', function(req, res) {
    const idList = req.params.id.split(',');

    res.send({
      geonamesids: _.reduce(idList, function(r, id) {
        r[id] = (id in geonamesMappings) ? geonamesMappings[id] : null;

        return r;
      }, {})
    });
  });

  app.use('/api/v1/geonames', v1GeonamesRouter);
};
