<?php

namespace CorpusParole\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{

    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        \Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode::class,
    ];
    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \CorpusParole\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \CorpusParole\Http\Middleware\VerifyCsrfToken::class,
        ],
        'api' => [
            'throttle:60,1',
            'bindings',
        ],
    ];
    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'auth' => \CorpusParole\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'guest' => \CorpusParole\Http\Middleware\RedirectIfAuthenticated::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'bindings' => \Illuminate\Routing\Middleware\SubstituteBindings::class,
    ];
    // /**
    //  * The application's global HTTP middleware stack.
    //  *
    //  * @var array
    //  */
    // protected $middleware = [
    //     // 'Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode',
    //     // 'Illuminate\Cookie\Middleware\EncryptCookies',
    //     // 'Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse',
    //     // 'Illuminate\Session\Middleware\StartSession',
    //     // 'Illuminate\View\Middleware\ShareErrorsFromSession',
    //     // 'CorpusParole\Http\Middleware\VerifyCsrfToken',
    // ];
    //
    // /**
    //  * The application's route middleware.
    //  *
    //  * @var array
    //  */
    // protected $routeMiddleware = [
    //     'auth' => 'CorpusParole\Http\Middleware\Authenticate',
    //     'auth.basic' => 'Illuminate\Auth\Middleware\AuthenticateWithBasicAuth',
    //     'guest' => 'CorpusParole\Http\Middleware\RedirectIfAuthenticated',
    // ];
}
