/*jshint node:true*/
/* global require, module */
var EmberApp = require('ember-cli/lib/broccoli/ember-app');

module.exports = function(defaults) {
    var app = new EmberApp(defaults, {
        // Add options here
        sassOptions: {
            includePaths: [
                'bower_components/bootstrap-sass/assets/stylesheets/'
            ]
        },
        fingerprint: {
            enabled: false
        }
    });

    // Use `app.import` to add additional libraries to the generated
    // output files.
    //
    // If you need to use different assets in different
    // environments, specify an object as the first parameter. That
    // object's keys should be the environment name and the values
    // should be the asset to use in that environment.
    //
    // If the library that you are including contains AMD or ES6
    // modules that you would like to import into your application
    // please specify an object with the list of modules as keys
    // along with the exports of each module as its value.
    app.import('bower_components/popcorn-js/popcorn.js');
    app.import('bower_components/ammap3/ammap/ammap.js');
    app.import('bower_components/chroma-js/chroma.js');
    app.import('vendor/data/maps/worldLow.js');
    app.import('vendor/data/maps/continentsLow.js');
    app.import('vendor/data/maps/france2016Low.js');
    app.import({
      development: 'bower_components/urijs/src/URI.js',
      production:  'bower_components/urijs/src/URI.min.js'
    });

    //shims
    app.import('vendor/shims/ammaps.js', {
        exports: {
            'ammaps': ['defaults']
        }
    });
    app.import('vendor/shims/popcorn.js', {
        exports: {
            'popcorn': ['defaults']
        }
    });
    app.import('vendor/shims/chroma.js', {
        exports: {
            'chroma': ['defaults']
        }
    });
    app.import('vendor/shims/urijs.js', {
      exports: {
        'urijs': [ 'default' ]
      }
    });

    //social-share-kit
    app.import('bower_components/social-share-kit/dist/js/social-share-kit.js');
    app.import('bower_components/social-share-kit/dist/css/social-share-kit.css');
    app.import('bower_components/social-share-kit/dist/fonts/social-share-kit.eot', { destDir: 'fonts'});
    app.import('bower_components/social-share-kit/dist/fonts/social-share-kit.svg', { destDir: 'fonts'});
    app.import('bower_components/social-share-kit/dist/fonts/social-share-kit.ttf', { destDir: 'fonts'});
    app.import('bower_components/social-share-kit/dist/fonts/social-share-kit.woff', { destDir: 'fonts'});
    app.import('vendor/shims/socialsharekit.js', {
      exports: {
        'socialsharekit': [ 'default' ]
      }
    });



    return app.toTree();
};
