<?php
namespace CorpusParole\Models;

use CorpusParole\Libraries\RdfModel\RdfModelResource;
use CorpusParole\Libraries\Utils;

use JsonSerializable;
use Log;


/**
 */
class TranscriptResource extends WebResource  {

    private $conformsTo = -1;


    protected function doClearMemoizationCache() {
        $this->conformsTo = -1;
    }

    public function getConformsTo() {
        if($this->conformsTo === -1) {
            $conformsTo = $this->getResource("<http://purl.org/dc/terms/conformsTo>");
            $this->conformsTo = is_null($conformsTo)?null:$conformsTo->getUri();
        }

        return $this->conformsTo;
    }


    protected function jsonSerializeExtra() {
        return [
            'conforms-to' => $this->getConformsTo()
        ];
    }

}