# PUPPI INFO README
The puppi info commands executes scripts in /etc/puppi/info/ which are generated by templates provided by the puppi::info define
These scripts are supposed to show status details on the omonimous info topic.

## SYNOPSIS (cli)
        puppi info [topic] [-i]

## EXAMPLES (cli)
Show host-wide infos. Much stuff.
        puppi info

Show info about apache (connections, processes, config, logs...)
        puppi info apache

Interactively select the info topics you want to show
        puppi info -i

Show complete info and send reports (email, rest ... )
        puppi info -r yes

Grep the output with the string defined
        puppi info -g <string>


## EXAMPLES (puppet)
The basic define related to a info is puppi::info, it creates a script executed
when running "puppi info $name" based on the provided template.
Customize the template to customize the info you want to see.

A sample that just runs commands using the default template:
        puppi::info { 'network':
          description => 'Network settings and stats' ,
          run         => [ 'ifconfig' , 'route -n' , 'cat /etc/resolv.conf' , 'netstat -natup | grep LISTEN' ],
        }

You can have more useful and dedicated info topics using a custom puppi::info define inside your
own defines. For example in a define that creates a tomcat instance you can add something like:
        puppi::info::instance { "tomcat-${instance_name}":
          servicename => "tomcat-${instance_name}",
          processname => "${instance_name}",
          configdir   => "${tomcat::params::storedir}/${instance_name}/conf/",
          bindir      => "${tomcat::params::storedir}/${instance_name}/bin/",
          pidfile     => "${instance_rundir}/tomcat-${instance_name}.pid",
          datadir     => "${instance_path}/webapps",
          logdir      => "${instance_logdir}",
          httpport    => "${instance_httpport}",
          controlport => "${instance_controlport}",
          ajpport     => "${instance_ajpport}",
          templatefile=> "puppi/info/instance.erb",
          description => "Info for ${instance_name} Tomcat instance" ,
        }
which has custom arguments, feeded by the data you provided to the define, and a custom
template file that uses these variables. 

## EXAMPLES (with example42 puppet modules)
If you use the old Example42 modules set you get automatically many service related infos out of the box to be used with Puppi One.
NextGen modules are supposed to provide pupi info intergration on Puppi Two (TO DO)
Just set (via an ENC, facts or manifests) $puppi=yes to enable puppi extensions autoloading.
This will automatically deploy info topics related to the modules you use.

