import Ember from 'ember';
import config from './config/environment';

const Router = Ember.Router.extend({

    location: config.locationType,
    rootURL: config.rootURL,

    player: Ember.inject.service(),

    didTransition:function() {
    	this.get('player').toggleVideoscreen(false);
    	this.get('player').displayMetadata(false);
    	this._super(...arguments);
    }
});

Router.map(function() {
    this.route('tabs/langues', { path: '/' });
    this.route('tabs/langues', { path: '/langues' });
    this.route('tabs/carto', { path: '/cartographie' });
    this.route('tabs/thematiques', { path: '/thematiques' });
    this.route('tabs/discours', { path: '/discours' });
    this.route('tabs/chrono', { path: '/chronologie' });
});

export default Router;
