class sysconfig::corpus (
    $vhost          = hiera('sysconfig::params::vhost',          $sysconfig::params::vhost),
    $corpus_app_key = hiera('sysconfig::params::corpus_app_key', $sysconfig::params::corpus_app_key),
    $db_name        = hiera('sysconfig::params::db_name',        $sysconfig::params::db_name),
    $db_drpl_name   = hiera('sysconfig::params::db_drpl_name',   $sysconfig::params::db_drpl_name),
    $db_user        = hiera('sysconfig::params::db_user',        $sysconfig::params::db_user),
    $db_pw          = hiera('sysconfig::params::db_pw',          $sysconfig::params::db_pw),
    $db_host        = hiera('sysconfig::params::db_host',        $sysconfig::params::db_host),
    $db_port        = hiera('sysconfig::params::db_port',        $sysconfig::params::db_port),
) inherits sysconfig::params {

    file { "/etc/www/corpus_env.conf":
        ensure => file,
        content => template("sysconfig/corpus/corpus_env.conf.erb"),
        require => [Package['httpd'], File['/etc/www']],
        notify => Service['httpd']
    }

    file { "/var/www/corpusdelaparole/corpus/.env":
        ensure => file,
        owner => 'apache',
        group => 'apache',
        content => template("sysconfig/corpus/local.env.erb"),
        require=>File["/var/www/corpusdelaparole/corpus"]
    }

}
