/*jshint node:true*/
var proxyPath = '/proxy/bnf';

module.exports = function(app) {
  // For options, see:
  // https://github.com/nodejitsu/node-http-proxy
  var proxy = require('http-proxy').createProxyServer({});

  proxy.on('error', function(err, req) {
    console.error(err, req.url);
  });

  app.use(proxyPath, function(req, res, next){
    // include root path in proxied request
    req.url = proxyPath + '/' + req.url;
    console.log(req.url);
    proxy.web(req, res, { target: 'http://data.bnf.fr/search-letter/' });
  });
};

//[{"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/14479749", "label": "testesttets"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/14954387", "label": "Testar"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16959857", "label": "Carole Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15613802", "label": "Lo\u00efc Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16723491", "label": "Julien Testard"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15123218", "label": "Elio Testoni"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15127173", "label": "Tatiana Testoni"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16993795", "label": "Nicole Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16738809", "label": "\u00c1ngeles Testera"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16750976", "label": "R\u00e9gis Testelin"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/11926262", "label": "Francesco Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/11983726", "label": "Testenoire-Lafayette (famille)"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12226862", "label": "Antonella Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16160005", "label": "Walter Testolin"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/10732566", "label": "Charles Teste"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16907072", "label": "Steven Tester"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12117943", "label": "Alain Teston"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12176852", "label": "Ada Testaferri"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15814125", "label": "B\u00e9atrice Testet"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12974154", "label": "Arnaldo Testi"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12985922", "label": "Louis Teste"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13081687", "label": "Maurice Testu"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/11926264", "label": "Jacques Testani\u00e8re"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13180517", "label": "Caroline Testut"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15046808", "label": "Jean Testard"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13322897", "label": "Thierry Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13323294", "label": "Bernard Testu"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16595811", "label": "Gaetano Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12254885", "label": "Yossel\u00e9 Testyler"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16579119", "label": "Quintin Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15707309", "label": "Eugenio Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13490877", "label": "Ines Testoni"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12007019", "label": "Paul Testard"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12277140", "label": "Jean Testas"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16539566", "label": "Roberto Testi"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16696900", "label": "Nic Testoni"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12306823", "label": "Fran\u00e7ois Testud"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16095049", "label": "N. Testekul"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13574614", "label": "Laura Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13575472", "label": "Ferdinando Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15508801", "label": "Giorgio Testi"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13595542", "label": "Hubert Testard"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15049141", "label": "Andrea Testa"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13609236", "label": "\u00c9lisabeth Testard"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16734894", "label": "David Testan"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16681032", "label": "Anna Testi"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/13749517", "label": "G\u00e9rard Teste"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/16507613", "label": "Leonardo Testi"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/15517824", "label": "Fr\u00e9d\u00e9ric Testu"}, {"category": "Auteurs (328 r\u00e9sultats)", "raw_category": "Person", "value": "http://data.bnf.fr/12161012", "label": "Luc Testut"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/16144833", "label": "Test\u00e9PourVous"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12373298", "label": "Testut"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14944765", "label": "Armando Testa"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14025594", "label": "Rorschach test"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12530939", "label": "Teste. Gironde. La"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/11990095", "label": "Tests. Paris"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/16490517", "label": "L\u00e9gr\u00e1dy Testv\u00e9rek"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12304804", "label": "Testis workshop"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12210721", "label": "Novi Testamenti Conventus"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13939486", "label": "Crash test dummies"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/15118256", "label": "Testsyf2 Crash Records"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14275359", "label": "154 Testa International"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14546755", "label": "Enzyme testing labs"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12218935", "label": "Magyar kir\u00e1lyi test\u0151rs\u00e9g"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12364911", "label": "Pocket testament league"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12410662", "label": "Educational testing service"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12525779", "label": "SHS-TEST"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12531733", "label": "Testa mora. Bastia"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13772141", "label": "Testuale. Milan, Italie"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12304806", "label": "North American testis Workshop (06 ; 1979 ; Houston, Tex.)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/15602909", "label": "Chinese proficiency Test. P\u00e9kin"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14637014", "label": "IEEE VLSI Test symposium (17 ; 1999 ; Dana Point, Calif.)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14708186", "label": "Ecole populaire de Testaccio"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13620053", "label": "North American testis workshop (14 ; 1997 ; Baltimore, Md.)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/16513006", "label": "Nordic New Testament conference (2007 ; Helsingborg, Su\u00e8de)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/16512300", "label": "Nordic New Testament conference (07 ; 2003 ; Stavanger, Norv\u00e8ge)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/15541154", "label": "European test & telemetry conference (2005 ; Toulouse)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12411859", "label": "Associu Testa mora Lyon"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/15072484", "label": "Nordic New Testament conference (06 ; 1999 ; Hiller\u00f8d, Danemark)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13906981", "label": "Test (Groupe de rock)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12147988", "label": "Oud-Testamentische werkgemeenschap"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14013592", "label": "Testament (Producteur de phonogrammes)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12148497", "label": "Studiorum novi testamenti societas"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12522503", "label": "North American testis workshop (08 ; 1983 ; Bethesda, Ma.)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14258528", "label": "Peter & the Test Tube Babies"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13906982", "label": "Testament (Groupe de hard rock)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12402002", "label": "European test and telemetry conference"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12513796", "label": "Sessio Veteri Testamento investigando destinata"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14624683", "label": "Colloquio internazionale Testo e contesto (02 ; 1996 ; Macerata, Italie)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/16088333", "label": "Arbeitskreis Rezeption des Alten Testaments"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12430592", "label": "Organization for testing in Europe"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12439696", "label": "American society for nondestructives testing"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/16710206", "label": "R\u00e9vai Testv\u00e9rek Irodalmi Int\u00e9zet. Budapest"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14627478", "label": "Colloquio internazionale Testo e contesto"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13508653", "label": "Seminari pasquali di analisi testuale (08 ; 1992 ; Baggni di Lucca, Italie)"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/11883738", "label": "World conference on nondestructive testing"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13508651", "label": "Seminari pasquali di analisi testuale"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/14440744", "label": "Groupe Tests. 01 Etudes. Paris"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/12851563", "label": "Mus\u00e9e Testud-Latarjet de m\u00e9decine et d'anatomie. Lyon"}, {"category": "Organisations (220 r\u00e9sultats)", "raw_category": "Org", "value": "http://data.bnf.fr/13566380", "label": "Seminari Pasquali di analisi testuale (10 ; 1994 ; Baggni di Lucca, Italie)"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12215111", "label": "Testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16249180", "label": "Testamentum"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16568166", "label": "Testimony"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16000450", "label": "Testamentum"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16119530", "label": "Testamento"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12530763", "label": "Testamento"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16174305", "label": "Testaments"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12008249", "label": "New Testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/14468510", "label": "Heiligenst\u00e4dter Testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/14425690", "label": "Das Testamentbuch"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16474609", "label": "Testet : film"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16622123", "label": "Le testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12103834", "label": "Testament politique"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16197697", "label": "Testimonia sanctorum"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/14781852", "label": "Testamentum asini"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12063001", "label": "Testament de Job"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12066668", "label": "Testament of Moses"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12066688", "label": "Testament d'Adam"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12066857", "label": "Testament of Abraham"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12066866", "label": "Testament d'Adam"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16473189", "label": "Greek testament : film"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12066881", "label": "Testament of Solomon"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16469519", "label": "Le Testament : film"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16650506", "label": "Testament de Cris\u00e8de"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16468343", "label": "Le Testament : film"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/13769662", "label": "Testi per nulla"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/13866637", "label": "Gi\u00f9 la testa"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16505655", "label": "Testament of Naphtali"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16211738", "label": "Pilgrim's testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/14662126", "label": "Il testimone : film"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12207167", "label": "Testament du Lingon"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/13598728", "label": "Testimonia divinae scripturae"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/13568546", "label": "Le dernier testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12261691", "label": "Testament d' Isaac"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16138501", "label": "In Vatinium testem"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/13336902", "label": "Testimony of truth"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/13985608", "label": "Testament. Voix, orchestre"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12008323", "label": "Bible. Ancien Testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12008385", "label": "Testament d'Ez\u00e9chias"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/14661857", "label": "Test pilot : film"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16739816", "label": "test DSI tic"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/16615329", "label": "Paradisus musicus testudinis"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/13981653", "label": "La testa di bronzo"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12003316", "label": "Paraphrases in Novum Testamentum"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12008246", "label": "Apocryphes du Nouveau Testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12011600", "label": "\u00c9p\u00eetres du Nouveau Testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12035234", "label": "Testament of our Lord"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12127611", "label": "Annotationes in Novum Testamentum"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12156837", "label": "Grand testament"}, {"category": "\u0152uvres (155 r\u00e9sultats)", "raw_category": "Work", "value": "http://data.bnf.fr/12426466", "label": "Mistere du Viel Testament"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11975828", "label": "Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12650563", "label": "Testerianos"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12011484", "label": "Testudinid\u00e9s"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11935669", "label": "Testament"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12307777", "label": "Testudo"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13564091", "label": "Testicardines"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11976787", "label": "Testis"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12262356", "label": "Testost\u00e9rone"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12006488", "label": "Testudines"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12372967", "label": "Testaments-partages"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13163032", "label": "Tests projectifs"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11965063", "label": "H\u00e9magglutination -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11965285", "label": "Histocompatibilit\u00e9 -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16628940", "label": "Cordon testiculaire"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13162863", "label": "Test P.N."}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13162722", "label": "Caract\u00e8re -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13162745", "label": "Tests mentaux"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13162746", "label": "Tests mentaux"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13162757", "label": "Aptitude -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11975370", "label": "Preuve testimoniale"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13162807", "label": "Z, Test"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/13162818", "label": "Ts\u00e8dek, Test"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16214459", "label": "Testudo cagado"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16214454", "label": "Testudo argentina"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16214450", "label": "Testudo boiei"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11932131", "label": "Tests mentaux"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16914849", "label": "Testudo fimbriata"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11979051", "label": "Tests objectifs"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11979349", "label": "Tests professionnels"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11979350", "label": "Cr\u00e9ativit\u00e9 -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11979802", "label": "R\u00e9flexes -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11979869", "label": "Toxicit\u00e9 -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11980416", "label": "Ex\u00e9cution testamentaire"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11983132", "label": "Mutag\u00e8nes -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11992439", "label": "Canc\u00e9rog\u00e8nes -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16762356", "label": "Testament spirituel"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11994576", "label": "Testour (Tunisie)"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11995833", "label": "Testaments litt\u00e9raires"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16209400", "label": "KET (test)"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12000631", "label": "Bourse testiculaire"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12002077", "label": "Testicule -- Hormones"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16174529", "label": "Testudo serpentina"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12006483", "label": "Peau -- Tests"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12007659", "label": "Testicule -- \u00c9chographie"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/16106020", "label": "Testudo gopher"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/11950704", "label": "Tests (technique)"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/12042297", "label": "Bible -- Testaments"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/15748688", "label": "Testudo marginata"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/15634569", "label": "Testudo horsfieldii"}, {"category": "Th\u00e8mes (225 r\u00e9sultats)", "raw_category": "Rameau", "value": "http://data.bnf.fr/15600493", "label": "Testudo gigantea"}, {"category": "Lieux (5 r\u00e9sultats)", "raw_category": "Geo", "value": "http://data.bnf.fr/15256575", "label": "La Teste (Gironde, France)"}, {"category": "Lieux (5 r\u00e9sultats)", "raw_category": "Geo", "value": "http://data.bnf.fr/15174367", "label": "La Teste, Cazaux (Gironde, France)"}, {"category": "Lieux (5 r\u00e9sultats)", "raw_category": "Geo", "value": "http://data.bnf.fr/15420607", "label": "\u00celes Los Testigos (Nueva Esparta, Venezuela)"}, {"category": "Lieux (5 r\u00e9sultats)", "raw_category": "Geo", "value": "http://data.bnf.fr/15804058", "label": "Tizi-n-Test, colline (Maroc)"}, {"category": "Lieux (5 r\u00e9sultats)", "raw_category": "Geo", "value": "http://data.bnf.fr/15191929", "label": "For\u00eat domaniale de La Teste (Gironde, France)"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/43520222", "label": "Testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39465298", "label": "Testarium"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/42631010", "label": "Testimony r\u00e9citatif"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39490675", "label": "Monsieur Teste"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39490674", "label": "Monsieur Teste"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/41366827", "label": "Le nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39477130", "label": "Le Nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39477321", "label": "Le nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/41150531", "label": "Testtttt SPE allong\u00e9"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39495616", "label": "Le nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39463412", "label": "Le Nouveau Testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39494274", "label": "Le nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39463413", "label": "Le Nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/42408118", "label": "Le nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/42355442", "label": "Le nouveau testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/44292208", "label": "Le testament de Vanda"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39467437", "label": "La Testament du chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39467978", "label": "Le mal de test"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39481493", "label": "Testament du P\u00e8re Leleu"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39487196", "label": "Le testament du jour"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39489167", "label": "Le Testament du chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39489168", "label": "Le Testament du chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39489169", "label": "Le Testament du chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39489508", "label": "Le Testament du Chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39489509", "label": "Le Testament du chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39491442", "label": "Le Testament des ogres"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39491443", "label": "Le Testament des ogres"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39491612", "label": "Le Mal de test"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39492512", "label": "Le testament du chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39496916", "label": "Le testament du chien"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39499141", "label": "Testament d'un r\u00e9mouleur"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/43551970", "label": "Le testament de Pantalone"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/43732860", "label": "Le testament de Vanda"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39460796", "label": "Le Testament de C\u00e9sar Girodot"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39481848", "label": "Le Testament du p\u00e8re Leleu"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39494435", "label": "Le testament de Fran\u00e7ois Villon"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39481847", "label": "Le Testament du p\u00e8re Leleu"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39459610", "label": "Le testament de C\u00e9sar Girodot"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39498437", "label": "Le testament du P\u00e8re Leleu"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39489523", "label": "Testament d'un sale Pierrot"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39489522", "label": "Testament d'un sale Pierrot"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39487068", "label": "Le Testament de Tante Caroline"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39466509", "label": "Le Testament de tante Caroline"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39494148", "label": "Le testament de tante Caroline"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39459312", "label": "Le testament du P\u00e8re Leleu"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/41241086", "label": "Le testament de M. de Crac"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39480584", "label": "Mikho\u00ebls ou le Testament d'un acteur juif"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39499056", "label": "Le P\u00e2ris de Sur\u00eane ou La clause du testament"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39467439", "label": "Le Testament du chien ou le Jeu de la Mis\u00e9ricordieuse"}, {"category": "Spectacles (51 r\u00e9sultats)", "raw_category": "Performance", "value": "http://data.bnf.fr/39467438", "label": "Le testament du chien ou Le jeu de la mis\u00e9ricordieuse"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34381602", "label": "Testemunho"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34512106", "label": "TEST"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34512736", "label": "Test"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34444003", "label": "[Test]"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34444011", "label": "[Test]"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/37577802", "label": "Testo"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34471445", "label": "Testuale"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34349845", "label": "[Test]"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/38937142", "label": "Testu"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34415903", "label": "Test magazine"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/43877726", "label": "Tests micro !"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/39228993", "label": "F\u00e9minin tests"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/39104567", "label": "Studi testuali"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34430450", "label": "Lang. test."}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/38901544", "label": "Test mag"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/43607776", "label": "G\u00e9ocarrefour (Test)"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/38880820", "label": "Nome testo"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34446122", "label": "Sp\u00e9cial tests"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/37587471", "label": "Cult. testo"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/32804703", "label": "La Teste-journal"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/37587066", "label": "Parola testo"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/42328139", "label": "Le Testament"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/37579175", "label": "Crit. testo"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/37575705", "label": "Testo fronte"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/36948821", "label": "Mobiles test"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/37014288", "label": "Phone test"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/42202000", "label": "Quad. Testuale"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34469355", "label": "Novum Testam."}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34540533", "label": "Test sant\u00e9"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/40200817", "label": "Auto test"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34471832", "label": "Vetus Testam."}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34381986", "label": "[Test comparaty]"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/44225294", "label": "Maxi tests"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/40053414", "label": "Ludo test"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/42440744", "label": "Micro portable tests"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34396905", "label": "[Test s\u00e9lection vacances]"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34418782", "label": "Tests VPC pratique"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34433338", "label": "Music test magazine"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34454055", "label": "Elenchos (Testo stamp.)"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34462600", "label": "Aevum (Testo stamp.)"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34464877", "label": "Cheiron (Testo stamp.)"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34469140", "label": "New. Testam. stud."}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34470512", "label": "Rinascimento (Testo stamp.)"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34519342", "label": "Planchemag. Sp\u00e9cial test"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34525982", "label": "Music test guitare"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34527941", "label": "Music test claviers"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/34536587", "label": "Culture-test"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/36136120", "label": "Test et vous"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/36137332", "label": "Test\u00e9 pour vous"}, {"category": "P\u00e9riodiques (162 r\u00e9sultats)", "raw_category": "Periodic", "value": "http://data.bnf.fr/37015530", "label": "Psycho test & loisirs"}]
