<?php

use Mockery as m;

use EasyRdf\Literal;

class DateStatsControllerTest extends TestCase
{
    const ES_QUERY = [
        'index' => 'corpus',
        'body' => [
            "size" => 0,
            "query" => [ "match_all" => [] ],
            "aggs" => [
                "datestats" => [
                    "nested"=> [
                        "path" => "creation_years"
                    ],
                    "aggs" => [
                        "years" => [
                            "terms"=> [
                                "field" => "creation_years.year",
                                "size" => 0,
                                "order" => [
                                    "_term" => "asc"
                                ]
                            ],
                            "aggs" => [
                                "year_count" => [
                                    "sum" => [
                                        "field" => "creation_years.weight"
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ]
    ];

    public function setUp() {

        parent::setup();
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }


    public function testIndexQuery() {

        Es::shouldReceive('search')
                ->once()
                ->with(self::ES_QUERY)
                ->andReturn(json_decode('{
                    "took" : 132,
                    "timed_out" : false,
                    "_shards" : {
                        "total" : 1,
                        "successful" : 1,
                        "failed" : 0
                    },
                    "hits" : {
                        "total" : 3373,
                        "max_score" : 0.0,
                        "hits" : [ ]
                    },
                    "aggregations" : {
                        "datestats" : {
                            "doc_count" : 3725,
                            "years" : {
                                "doc_count_error_upper_bound" : 0,
                                "sum_other_doc_count" : 0,
                                "buckets" : []
                            }
                        }
                    }
                }', true));
            $this->get('/api/v1/stats/datestats/')->assertTrue($this->response->isOk(), $this->response->content());
            $this->seeJsonEquals(["datestats" => []]);
    }

    public function testIndexResult() {

        Es::shouldReceive('search')
                ->once()
                ->with(self::ES_QUERY)
                ->andReturn(json_decode('{
                    "took" : 132,
                    "timed_out" : false,
                    "_shards" : {
                        "total" : 1,
                        "successful" : 1,
                        "failed" : 0
                    },
                    "hits" : {
                        "total" : 3373,
                        "max_score" : 0.0,
                        "hits" : [ ]
                    },
                    "aggregations" : {
                        "datestats" : {
                            "doc_count" : 3725,
                            "years" : {
                                "doc_count_error_upper_bound" : 0,
                                "sum_other_doc_count" : 0,
                                "buckets" : [ {
                                    "key" : 1948,
                                    "doc_count" : 3,
                                    "year_count" : { "value" : 3.0 }
                                }, {
                                    "key" : 1957,
                                    "doc_count" : 29,
                                    "year_count" : { "value" : 29.0 }
                                }, {
                                    "key" : 1963,
                                    "doc_count" : 22,
                                    "year_count" : { "value" : 21.5 }
                                },  {
                                    "key" : 1970,
                                    "doc_count" : 411,
                                    "year_count" : { "value" : 403.68333334475756 }
                                },  {
                                    "key" : 1986,
                                    "doc_count" : 68,
                                    "year_count" : { "value" : 14.133333388715982 }
                                }, {
                                    "key" : 1996,
                                    "doc_count" : 40,
                                    "year_count" : { "value" : 36.05000001564622 }
                                } ]
                            }
                        }
                    }
                }', true));
            $this->get('/api/v1/stats/datestats/')->assertTrue($this->response->isOk(), $this->response->content());
            $this->seeJsonEquals(["datestats" => [
                "1948" => 3,
                "1957" => 29,
                "1963" => 22,
                "1970" => 404,
                "1986" => 14,
                "1996" => 36
            ]]);
    }

}
