<?php

namespace CorpusParole\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\PaginationServiceProvider as BasePaginationServiceProvider;
use Illuminate\Pagination\Paginator;

use Log;

class PaginationServiceProvider extends BasePaginationServiceProvider
{

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        parent::register();
        Paginator::currentPathResolver(function () {
            $r = $this->app['request'];
            $queryParams = $r->all();
            unset($queryParams[config('corpusparole.pagination_page_param')]);

            $question = $r->getBaseUrl().$r->getPathInfo() == '/' ? '/?' : '?';
            return $r->url().$question.http_build_query($queryParams);
        });

    }
}
