<?php
namespace CorpusParole\Providers;

use Illuminate\Support\ServiceProvider;

/**
 * Service provider charged to bind repository interfaces to implementations
 */
class RepositoryServiceProvider extends ServiceProvider {

    public function register() {
        $this->app->bind(
            'CorpusParole\Repositories\DocumentRepository',
            function($app) {

                $httpClient = $app->make('GuzzleHttp\Client', [[ 'base_uri' => config('corpusparole.sesame_query_url'), 'http_errors' => false]]);
                $sparqlClient = $app->make('EasyRdf\Sparql\Client', [config('corpusparole.sesame_query_url'), config('corpusparole.sesame_update_url')]);
                $cpSparqlClient = $app->make('CorpusParole\Libraries\Sparql\SparqlClient', [$httpClient, $sparqlClient]);
                return $app->make('CorpusParole\Repositories\RdfDocumentRepository', [$cpSparqlClient,]);
            }
        );
    }
}
