<?php
namespace CorpusParole\Libraries;

use EasyRdf\Resource;

class CocoonUtils {

    const OLAC_ROLES = [
        'http://www.language-archives.org/OLAC/1.1/annotator',
        'http://www.language-archives.org/OLAC/1.1/author',
        'http://www.language-archives.org/OLAC/1.1/compiler',
        'http://www.language-archives.org/OLAC/1.1/consultant',
        'http://www.language-archives.org/OLAC/1.1/data_inputter',
        'http://www.language-archives.org/OLAC/1.1/depositor',
        'http://www.language-archives.org/OLAC/1.1/developer',
        'http://www.language-archives.org/OLAC/1.1/editor',
        'http://www.language-archives.org/OLAC/1.1/illustrator',
        'http://www.language-archives.org/OLAC/1.1/interpreter',
        'http://www.language-archives.org/OLAC/1.1/interviewer',
        'http://www.language-archives.org/OLAC/1.1/participant',
        'http://www.language-archives.org/OLAC/1.1/performer',
        'http://www.language-archives.org/OLAC/1.1/photographer',
        'http://www.language-archives.org/OLAC/1.1/recorder',
        'http://www.language-archives.org/OLAC/1.1/researcher',
        'http://www.language-archives.org/OLAC/1.1/research_participant',
        'http://www.language-archives.org/OLAC/1.1/responder',
        'http://www.language-archives.org/OLAC/1.1/signer',
        'http://www.language-archives.org/OLAC/1.1/singer',
        'http://www.language-archives.org/OLAC/1.1/speaker',
        'http://www.language-archives.org/OLAC/1.1/sponsor',
        'http://www.language-archives.org/OLAC/1.1/transcriber',
        'http://www.language-archives.org/OLAC/1.1/translator',
    ];

    /**
     * Extract id from cocoon url.
     *
     * @return string
     */
    public static function getIdFromUri($uri) {
        return config('corpusparole.corpus_id_scheme').substr($uri, strlen(config('corpusparole.cocoon_doc_id_base_uri')));
    }

    /**
     * Extract Cocoon id from Cocoon url.
     *
     * @return string
     */
    public static function getCocoonIdFromCorpusUri($uri) {
        return substr($uri, strlen(config('corpusparole.corpus_doc_id_base_uri')));
    }

    /**
     * Extract id form corpus url.
     *
     * @return string
     */
    public static function getIdFromCorpusUri($uri) {
        return config('corpusparole.corpus_id_scheme').substr($uri, strlen(config('corpusparole.corpus_doc_id_base_uri')));
    }

    /**
     * Create a Corpus resource id (purl url)
     *
     * @return string
     */
    public static function getCorpusUriFromId($id) {
        if(strpos($id, config('corpusparole.corpus_id_scheme')) === 0) {
            $id = substr($id, strlen(config('corpusparole.corpus_id_scheme')));
        }
        return rtrim(config('corpusparole.corpus_doc_id_base_uri'),'/')."/$id";
    }

    public static function getCocoonPubUrl($id) {
        if(strpos($id, config('corpusparole.corpus_id_scheme')) === 0) {
            $id = substr($id, strlen(config('corpusparole.corpus_id_scheme')));
        }
        return rtrim(config('corpusparole.cocoon_doc_pub_base_uri'), '/')."/$id";
    }

    public static function isResourceCollection($res) {
        return $res instanceof Resource && (
            (strpos(strtolower($res->getUri()), "collection", strlen(config('corpusparole.cocoon_doc_id_base_uri'))) !== FALSE) ||
            (strpos(strtolower($res->getUri()), "collection", strlen(config('corpusparole.corpus_doc_id_base_uri'))) !== FALSE)
        );
    }

    public static function getGeonamesidFromUrl($url) {
        $matches = [];
        if(preg_match(config('corpusparole.geonames_url_regexp'), $url, $matches) === 1) {
            return $matches[1];
        }
        else {
            return null;
        }
    }

}
