<?php

namespace CorpusParole\Providers;

use Config;

use Illuminate\Support\ServiceProvider;

class LexvoServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('CorpusParole\Services\LexvoResolverInterface', function($app) {
            $sparqlClient = $app->make('CorpusParole\Libraries\Sparql\GuzzleSparqlClient', [$app['Guzzle'], config('corpusparole.lexvo_rdf4j_query_url'), null]);
            return $app->make('CorpusParole\Services\LexvoResolver', [$sparqlClient,]);
        });
    }
}
