import Ember from 'ember';
import layout from '../templates/components/doc-contributor';
import * as utils from 'corpus-common-addon/utils/utils';

export default Ember.Component.extend({
  layout: layout,
  tagName: 'span',

  viafResolver: Ember.inject.service(),

  _resolveViafIds: Ember.on('init', Ember.observer('url', function () {
    this.get('viafResolver').getName(this.get('url'))
      .then(function (str) {
        if (!(this.get('isDestroyed') || this.get('isDestroying'))) {
          this.set('resolvedName', str);
        }
      }.bind(this));
  })),

  code: Ember.computed('url', function () {
    return utils.getViafCode(this.get('url'));
  }),
  isContributorLink: Ember.computed('url', function () {
    return utils.isViafLink(this.get('url'));
  })

});
