import * as utils from 'corpus-common-addon/utils/utils';

import ResolverService from 'corpus-common-addon/services/resolver-service';

export default ResolverService.extend({

  storeKeyBase: 'geonames',
  apiPath: '/api/v1/resolvers/geonames/',
  resDocRoot: 'geonamesids',

  init(...args) {
    this._super(args);
  },

  processId: function (id) {
    return utils.getGeonamesCode(id);
  },

  getReturnDictKey: function (id) {
    return id;
  },

  getLabel: function (id) {
    return this.getName(id);
  }

});
