<?php

use CorpusParole\Libraries\Utils;

class UtilsTest extends TestCase {
    function __construct(string $name = null) {
        parent::__construct($name);
    }

    public function setup() {
    }

    public function tearDown() {
    }

    public function testDateIntervalToMillis() {
        $di = new \DateInterval("P1Y1M1DT1H1M1S");

        $ms = Utils::dateIntervalToMillis($di);

        $this->assertEquals(34277461000, $ms, "duration must be 3427746100");
    }

    public function testiso8601IntervalToMillis() {
        $ms = Utils::iso8601IntervalToMillis("P1Y1M1DT1H1M1S");
        $this->assertEquals(34277461000, $ms, "duration must be 3427746100");
    }

    public function testiso8601IntervalToMillisNull() {
        $ms = Utils::iso8601IntervalToMillis(null);
        $this->assertNull($ms, "duration must be null");
    }

}
