@extends('app')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-10 col-md-offset-1">
            <div class="panel panel-default">
                <div class="panel-heading">@lang('bo.document_list')</div>

                <div class="panel-body">
                    <table class="table table-striped">
                        <thead>
                            <tr><th>ID</th><th>TITRE</th><th>LANG.</th><th>DATE</th></tr>
                        </thead>
                        <tbody>
                        @foreach ($docs as $doc)
                            <tr>
                                <td>
                                    <a href="{{ route('bo.docs.client',[ 'id' => $doc->getId()]) }}#/doc/{{ $doc->getId() }}">{{ $doc->getId() }}</a>
                                </td>
                                <td>{{ $doc->getTitle() }}</td>
                                <td><a href="{{ $doc->getLanguageValue() }}" target="_blank" title="{{ $languageNames[$doc->getLanguageValue()]}}">{{substr($doc->getLanguageValue(), 29)}}</td>
                                <td>{{ $doc->getModified() }}</td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                    {!! $docs->render() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
