class sysconfig::apache (
    $vhost = hiera('sysconfig::params::vhost', $sysconfig::params::vhost),
) inherits sysconfig::params {
    notify {'apache': name => "\$vhost : ${vhost}", withpath => true }

    #remove system apache
    # package { "audit-libs":
    #     ensure => present
    # }->
    # package {"rhscl-httpd24-epel-7-x86_64":
    #     ensure => present,
    #     source => "https://www.softwarecollections.org/en/scls/rhscl/httpd24/epel-7-x86_64/download/rhscl-httpd24-epel-7-x86_64.noarch.rpm",
    #     provider => rpm,
    # }->
    # class { '::apache':
    #     default_vhost => false,
    #     apache_name => 'httpd24-httpd',
    #     service_name => 'httpd24-httpd',
    #     httpd_dir => "/opt/rh/httpd24/root/etc/httpd",
    #     server_root => "/opt/rh/httpd24/root/etc/httpd",
    #     conf_dir => "/opt/rh/httpd24/root/etc/httpd/conf",
    #     confd_dir => "/opt/rh/httpd24/root/etc/httpd/conf.d",
    #     mod_dir => "/opt/rh/httpd24/root/etc/httpd/conf.d",
    #     vhost_dir => "/opt/rh/httpd24/root/etc/httpd/conf.d",
    #     ports_file => "/opt/rh/httpd24/root/etc/httpd/conf.d/ports.conf"
    # }
    # class { '::apache':
    #     default_vhost => false,
    #     server_signature => 'off',
    #     server_tokens => 'prod'
    # }
    # file {[ "/var/www/corpusdelaparole",
    #         "/var/www/corpusdelaparole/corpus",
    #         "/var/www/corpusdelaparole/drupal"]:
    #     ensure => directory,
    #     owner => 'apache',
    #     group => 'apache'
    # }->
    # file { "/etc/www":
    #     ensure => directory,
    # }->
    # ::apache::vhost { $vhost:
    #     port    => '80',
    #     docroot => "/var/www/corpusdelaparole/drupal",
    #     options => ['-indexes'],
    #     aliases => [
    #         { alias => '/corpus', path => "/var/www/corpusdelaparole/corpus/public" },
    #     ],
    #     use_optional_includes => true,
    #     directories => [
    #         {
    #             path => "/var/www/corpusdelaparole/drupal",
    #             allow_override => ['all',]
    #         },
    #         {
    #             path => "/var/www/corpusdelaparole/corpus/public",
    #             allow_override => ['all',],
    #         }
    #     ],
    #     custom_fragment => "  <Location /corpus>\n    IncludeOptional /etc/www/corpus_env.con[f]\n  </Location>",
    # }

    $apache_packages = [
        'httpd'
    ]
    $corpus_folders = [
        "/var/www/corpusdelaparole",
        "/var/www/corpusdelaparole/corpus",
        "/var/www/corpusdelaparole/drupal"
    ]

    package { $apache_packages:
        ensure => present,
    }

    service { "httpd":
        ensure => running,
        enable => true,
        require => Package['httpd']
    }

    file { $corpus_folders:
        ensure => directory,
        owner => 'apache',
        group => 'apache',
        require => Package['httpd']
    }

    file { "/etc/www":
        ensure => directory,
    }

    file { ["/etc/httpd/conf.d/userdir.conf", "/etc/httpd/conf.d/autoindex.conf"]:
        ensure => absent,
        require => Package['httpd'],
        notify => Service['httpd']
    }
    file { "/etc/httpd/conf/httpd.conf":
        ensure => file,
        source => "puppet:///modules/sysconfig/httpd/httpd.conf",
        require => Package['httpd'],
        notify => Service['httpd']
    }
    file { "/etc/httpd/conf.d/welcome.conf":
        ensure => file,
        source => "puppet:///modules/sysconfig/httpd/welcome.conf",
        require => Package['httpd'],
        notify => Service['httpd']
    }
    file { "/etc/httpd/conf.d/10-corpusdelaparole.conf":
        ensure => file,
        content => template("sysconfig/httpd/vhost.conf.erb"),
        require => [Package['httpd'], File['/etc/www'], File[$corpus_folders]],
        notify => Service['httpd']
    }

    exec { "open-http-port":
        command => "firewall-cmd --permanent --add-port=80/tcp",
        path => [ '/bin', '/usr/bin', '/usr/local/bin' ]
    }->
    exec { "open-http-port-reload":
        command => "firewall-cmd --reload",
        path => [ '/bin', '/usr/bin', '/usr/local/bin' ]
    }

    #remove
    #/etc/httpd/conf.d/userdir.conf
    #/etc/httpd/conf.d/autotindex.conf
    #/etc/httpd/conf.d/welcome.conf

}
