<?php

namespace CorpusParole\Http\Controllers\Api;

// use Illuminate\Http\Request;
// use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;

use Illuminate\Http\Request;
use EasyRdf\Resource;
use EasyRdf\Literal;

use Es;
use Log;

use CorpusParole\Libraries\Sparql\SparqlClient;
use CorpusParole\Services\LexvoResolverInterface;
use CorpusParole\Services\BnfResolverInterface;


class ThemeController extends Controller
{
    private $sparqlClient = null;

    public function __construct(SparqlClient $sparqlClient, LexvoResolverInterface $lexvoResolver, BnfResolverInterface $bnfResolver) {
        $this->sparqlClient = $sparqlClient;
        $this->lexvoResolver = $lexvoResolver;
        $this->bnfResolver = $bnfResolver;
    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $index = $request->input('index', 0);
        $limit = $request->input('limit', 0);
        $sort = $request->input('sort', 'count');


        if($sort == "count" || $sort == "descending") {
            $order_field = "_count";
            $order_dir = "desc";
        } elseif($sort == "-count") {
            $order_field = "_count";
            $order_dir = "asc";
        } elseif ($sort == "label" || $sort == "alphabetical") {
            $order_field = "_term";
            $order_dir = "asc";
        } elseif ($sort == "-label") {
            $order_field = "_term";
            $order_dir = "desc";
        } else {
            $order_field = "_count";
            $order_dir = "desc";
        }

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => $limit * ($index+1),
                                    "order" => [ $order_field => $order_dir ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        $esRes = Es::search($query);

        $themes = [];

        $bucketList = array_slice($esRes['aggregations']['subjects']['subjects']['buckets'], $index*$limit, $limit);

        foreach($bucketList as $bucket) {
            $parts = explode("|", $bucket['key']);
            $label = $parts[0];
            $url = config('corpusparole.bnf_ark_base_url').$parts[1];
            $themes[$url] = [
                "label" => $label,
                "count" => $bucket['doc_count']
            ];
        }

        return response()->json(['themes' => $themes ]);

    }

}
