(function($) {

Drupal.behaviors.moduleFilterUpdateStatus = {
  attach: function(context) {
    $('#module-filter-update-status-form').once('update-status', function() {
      var filterInput = $('input[name="module_filter[name]"]', context);
      filterInput.moduleFilter('table.update > tbody > tr', {
        wrapper: $('table.update:first').parent(),
        delay: 300,
        childSelector: 'div.project a',
        rules: [
          function(moduleFilter, item) {
            switch (moduleFilter.options.show) {
              case 'all':
                return true;
              case 'updates':
                if (item.state == 'warning' || item.state == 'error') {
                  return true;
                }
                break;
              case 'security':
                if (item.state == 'error') {
                  return true;
                }
                break;
              case 'ignore':
                if (item.state == 'ignored') {
                  return true;
                }
                break;
              case 'unknown':
                if (item.state == 'unknown') {
                  return true;
                }
                break;
            }
            return false;
          }
        ],
        buildIndex: [
          function(moduleFilter, item) {
            if ($('.version-status', item.element).text() == Drupal.t('Ignored from settings')) {
              item.state = 'ignored';
              return item;
            }
            if (item.element.is('.ok')) {
              item.state = 'ok';
            }
            else if (item.element.is('.warning')) {
              item.state = 'warning';
            }
            else if (item.element.is('.error')) {
              item.state = 'error';
            }
            else if (item.element.is('.unknown')) {
              item.state = 'unknown';
            }
            return item;
          }
        ],
        show: $('#edit-module-filter-show input[name="module_filter[show]"]', context).val()
      });

      var moduleFilter = filterInput.data('moduleFilter');

      if (Drupal.settings.moduleFilter.rememberUpdateState) {
        var updateShow = Drupal.ModuleFilter.getState('updateShow');
        if (updateShow) {
          moduleFilter.options.show = updateShow;
          $('#edit-module-filter-show input[name="module_filter[show]"][value="' + updateShow + '"]', context).click();
        }
      }

      $('#edit-module-filter-show input[name="module_filter[show]"]', context).change(function() {
        moduleFilter.options.show = $(this).val();
        Drupal.ModuleFilter.setState('updateShow', moduleFilter.options.show);
        moduleFilter.applyFilter();
      });

      moduleFilter.element.bind('moduleFilter:start', function() {
        $('table.update').each(function() {
          $(this).show().prev('h3').show();
        });
      });

      moduleFilter.element.bind('moduleFilter:finish', function(e, data) {
        $('table.update').each(function() {
          var $table = $(this);
          if ($('tbody tr', $(this)).filter(':visible').length == 0) {
            $table.hide().prev('h3').hide();
          }
        });
      });

      moduleFilter.element.bind('moduleFilter:keyup', function() {
        if (moduleFilter.clearOffset == undefined) {
          moduleFilter.inputWidth = filterInput.width();
          moduleFilter.clearOffset = moduleFilter.element.parent().find('.module-filter-clear a').width();
        }
        if (moduleFilter.text) {
          filterInput.width(moduleFilter.inputWidth - moduleFilter.clearOffset - 5).parent().css('margin-right', moduleFilter.clearOffset + 5);
        }
        else {
          filterInput.width(moduleFilter.inputWidth).parent().css('margin-right', 0);
        }
      });

      moduleFilter.element.parent().find('.module-filter-clear a').click(function() {
        filterInput.width(moduleFilter.inputWidth).parent().css('margin-right', 0);
      });

      moduleFilter.applyFilter();
    });
  }
};

})(jQuery);
