#!/bin/bash
#
clear
TARFILE=sources.tar.gz
DUMP=corpusdelaparole.sql
APUSER=apache
APGROUP=apache
# Variable de configuration à modifier selon vos besoins
#########################################################
ROOT=/var/www/corpusdelaparole/drupal/
#########################################################
splashTitle() {
cat <<"EOT"
                __ _   _____                         _    _____      _
               / _(_) |  __ \                       | |  / ____|    | |
          __ _| |_ _  | |  | |_ __ _   _ _ __   __ _| | | (___   ___| |_ _   _ _ __
         / _` |  _| | | |  | | '__| | | | '_ \ / _` | |  \___ \ / _ \ __| | | | '_ \
        | (_| | | | | | |__| | |  | |_| | |_) | (_| | |  ____) |  __/ |_| |_| | |_) |
         \__, |_| |_| |_____/|_|   \__,_| .__/ \__,_|_| |_____/ \___|\__|\__,_| .__/
          __/ |                         | |                                   | |
         |___/                          |_|                                   |_|

EOT
}

splashTitle
export DRUSH_OPTIONS="-q"
echo "--------------------------- PARAMETRES D'INSTALLATION -------------------------------------------------------"
echo "------------ A modifier dans le fichier sites/default/settings.php au besoin --------------------------------"
echo "-------------------------------------------------------------------------------------------------------------"
drush -r $ROOT sql-conf
echo "-------------------------------------------------------------------------------------------------------------"
echo "-------------------------------------------------------------------------------------------------------------"
read -r -p "Etes-vous sur(e) de vouloir installer avec les paramètres ci dessus ? [Oui/n]" response
 response=${response,,} # tolower
 if [[ $response =~ ^(oui|o| ) ]]; then
    #
    echo ""
    echo ""
    echo "-------------------- Installation du site corpus de la parole -----------------------------------------------"
    echo "-------------------------------------------------------------------------------------------------------------"
    #
    # Errors are fatal
    #
    set -e

    echo ""
    echo "Copie des sources et du dump SQL dans $ROOT"
    echo "-------------------------------------------"
    echo "cp $TARFILE $ROOT/$TARFILE"
    cp "$TARFILE" "$ROOT/$TARFILE"
    echo "cp $DUMP $ROOT/$TARFILE"
    cp "$DUMP" "$ROOT/$DUMP"
    echo ">> Copie effectuée avec succès"
    echo ""

    cd $ROOT
    echo "Extraction des sources dans $ROOT"
    echo "---------------------------------"
    echo "tar -xf $TARFILE --strip 1"
    tar -xf $TARFILE --strip 1
    echo ">> Extraction effectuée avec succès"
    echo ""
    echo ""
    echo "Vidage de la base de données"
    echo "------------------------------------------------"
    echo "drush -r $ROOT sql-drop -y"
    drush -r $ROOT sql-drop -y

    echo ""
    echo "Restauration du dump de bdd dans la base de données"
    echo "------------------------------------------------"
    echo "drush -r $ROOT sql-cli < $DUMP"
    drush -r $ROOT sql-cli < $DUMP

    echo ""
    echo "Application des mises à jour de base de données si besoin"
    echo "------------------------------------------------"
    echo "drush -r $ROOT updb -y"
    drush -r $ROOT updb -y

    echo ""
    echo "Vidage des tables accesslog,search_dataset,search_index,search_total,sessions,watchdog"
    echo "--------------------------------------------------------------------------------------"
    drush -r $ROOT sql-query "TRUNCATE TABLE accesslog"
    drush -r $ROOT sql-query "TRUNCATE TABLE search_dataset"
    drush -r $ROOT sql-query "TRUNCATE TABLE search_index"
    drush -r $ROOT sql-query "TRUNCATE TABLE search_total"
    drush -r $ROOT sql-query "TRUNCATE TABLE sessions"
    drush -r $ROOT sql-query "TRUNCATE TABLE watchdog"
    echo ">> Restauration effectuée avec succès"
    echo ""
    echo "Suppression de l'archive tar et du dump"
    echo "-----------------------------------------------------"
    rm "$ROOT/$TARFILE"
    rm "$ROOT/$DUMP"
    echo ">> Suppression effectuée avec succès"
    echo ""
    echo "Attribution des droits apache (httpd) sur les sources"
    echo "-----------------------------------------------------"
    echo "chown -R $APUSER:$APGROUP $ROOT/*"
    chown -R $APUSER:$APGROUP $ROOT/*
    echo ">> Droits apache attribués avec succès"
    echo ""

    echo "Vidage des caches Drupal"
    echo "-----------------------------------------------------"
    drush -r $ROOT cc all
    set -e

    echo ""
    echo ""
    echo ">>>>>>>>>>>>>> INSTALLATION EFFECTUEE AVEC SUCCESS"
    echo ""
    echo ""
 fi
