var gulp = require('gulp');
var elixir = require('laravel-elixir');
var del = require('del');
var seq = require('run-sequence');
var minimist = require('minimist');
var util = require("gulp-util");

var exec = require('child_process').execSync;

var options = minimist(process.argv.slice(2));

var buildOption = "--prod";
if(options.production) {
    buildOption = "--prod";
} else if(options.development) {
    buildOption = "--dev";
}


var paths = {
 'bower_base_path': './vendor/bower_components/',
 'bootstrap': './vendor/bower_components/bootstrap-sass/assets/'
 };

gulp.task('build-ember', function(cb) {
    exec('node_modules/.bin/ember build '+buildOption, {
        cwd: '../bo_client',
        stdio:[0,1,2]
    });
});

gulp.task('copy-bo-ember', function() {
    gulp.src('../bo_client/dist/assets/*.js')
        .pipe(gulp.dest('public/js/vendor/'));
    gulp.src('../bo_client/dist/assets/*.css')
        .pipe(gulp.dest('public/css/'));
    gulp.src('../bo_client/dist/fonts/**/*')
        .pipe(gulp.dest('public/fonts/'));
    gulp.src('../bo_client/dist/assets/img/**/*')
        .pipe(gulp.dest('public/css/img'));

});

gulp.task('do-copy-to-build', function() {
    del(['../../build/root/var/www/corpusdelaparole/corpus-back/**/*'], {force: true}).then(function(files) {
        gulp.src(['**/*','!vendor', '!vendor/**', '!node_modules', /*'!public/corpus-app', '!public/corpus-app/**',*/ '!node_modules/**', '!.env', '!.git*', '!bootstrap/cache/**'])
            .pipe(gulp.dest('../../build/root/var/www/corpusdelaparole/corpus-back/'))
            .on("finish", function() {
                util.log("corpus-back files copied");
            });
    });
});

elixir(function(mix) {
    mix.sass('app.scss', 'public/css/app.css', null, {includePaths: [paths['bootstrap']+'stylesheets/']})
        .scripts(['sparqlclient.js'], 'public/js/sparqlclient.js')
        .copy('resources/assets/sass/img', 'public/css/img')
        .copy(paths.bootstrap + 'fonts/bootstrap', 'public/fonts')
        .copy(paths.bootstrap + 'javascripts/bootstrap.js', 'public/js/vendor/bootstrap.js')
        .copy(paths.bower_base_path + 'yasqe/dist/yasqe.bundled.min.js', 'public/js/vendor/yasqe.bundled.min.js')
        .copy(paths.bower_base_path + 'yasr/dist/yasr.bundled.min.js', 'public/js/vendor/yasr.bundled.min.js')
        .copy(paths.bower_base_path + 'jquery/dist/jquery.min.js', 'public/js/vendor/jquery.js')
        .copy(paths.bower_base_path + 'yasqe/dist/yasqe.min.css', 'public/css/vendor/yasqe.min.css')
        .copy(paths.bower_base_path + 'yasr/dist/yasr.min.css', 'public/css/vendor/yasr.min.css')
        .copy(paths.bower_base_path + 'font-awesome/css/font-awesome.min.css', 'public/css/vendor/font-awesome.css')
        .task('build-ember')
        .task('copy-bo-ember');
});

gulp.task('copy-build', function(cb) {
    return seq('default', 'do-copy-to-build', cb);
});

