import Ember from 'ember';
import layout from '../templates/components/doc-literal';

export default Ember.Component.extend({
  layout: layout,
  tagName: 'span',
  value: Ember.computed('url', function () {
    const url = this.get('url');

    if (typeof url === 'string') {
      return url;
    } else if (typeof url === 'object' && !Array.isArray(url) && 'value' in url) {
      return url.value;
    }

    return null;
  }),
  lang: Ember.computed('url', function () {
    const url = this.get('url');

    if (typeof url === 'object' && !Array.isArray(url) && 'lang' in url) {
      return url.lang;
    }

    return null;
  }),

  datatype: Ember.computed('url', function () {
    const url = this.get('url');

    if (typeof url === 'object' && !Array.isArray(url) && 'datatype' in url) {
      return url.datatype;
    }

    return null;
  })

});
