import Ember from 'ember';
import layout from '../templates/components/doc-created';
import * as utils from 'corpus-common-addon/utils/utils';

export default Ember.Component.extend({
  layout: layout,
  tagName: 'span',
  value: null,
  formatDate: function (dateStr, dateParsed) {
    if (!dateStr) {
      return Ember.String.htmlSafe('');
    }
    if (/^\d{4}$/.test(dateStr)) {
      return Ember.String.htmlSafe(dateStr);
    }

    const date = dateParsed || new Date(dateStr);

    if (isNaN(date.getTime())) {
      return Ember.String.htmlSafe('Date inconnue');
    }

    if (/^\d{4}-\d{2}$/.test(dateStr)) {
      return Ember.String.htmlSafe((date.getMonth() + 1) + '-' + date.getFullYear());
    }

    return Ember.String.htmlSafe(date.getDate() + '-' + (date.getMonth() + 1) + '-' + date.getFullYear());
  },
  shortDateDate: Ember.computed('value', function () {
    return this.formatDate(this.get('value'));
  }),
  periodMatches: Ember.computed('value', function () {
    const dateStr = this.get('value');

    return utils.getPeriodMatches(dateStr);
  }),
  isPeriod: Ember.computed('periodMatches', function () {
    const periodMatches = this.get('periodMatches');

    return Boolean(periodMatches);
  }),
  shortDateStart: Ember.computed('periodMatches', function () {
    const periodMatches = this.get('periodMatches');

    if (!periodMatches) {
      return null;
    }

    // from the periodMatches function we know that we have a valid start date
    return this.formatDate(periodMatches.start.str, periodMatches.start.date);

  }),
  shortDateEnd: Ember.computed('periodMatches', function () {
    const periodMatches = this.get('periodMatches');

    if (!periodMatches) {
      return null;
    }

    // from the periodMatches function we know that we have a valid end date
    return this.formatDate(periodMatches.end.str, periodMatches.end.date);

  }),
  click() {
    const action = this.get('action');

    if (action) {
      action();
    }
  }

});
