import DS from 'ember-data';
import Ember from 'ember';

var Document = DS.Model.extend({
  // id: DS.attr('string'),
  uri: DS.attr('string'),
  title: DS.attr('string'),
  language: DS.attr('string'),
  publishers: DS.attr({defaultValue: []}),
  contributors: DS.attr({defaultValue: []}),
  mediaArray: DS.attr({defaultValue: []}),
  mediaList: Ember.computed('mediaArray', function() {
    var res = [];
    var mp3 = null;
    Ember.$.forEach(this.get('mediaArray'), function(m) {
      if(m.format === 'audio/mpeg') {
        mp3 = m;
      } else if (m.format.startsWith('audio/')) {
        res.push(m);
      }
    });
    if(mp3) {
      res.unshift(mp3);
    }
    return res;
  })
});

Document.reopenClass({
  FIXTURES: [
    {
      "id": "crdo-09-CAYCHAX_SOUND",
      "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-CAYCHAX_SOUND",
      "title": "ALLOc : Caychax : Parabole",
      "language": "http://lexvo.org/id/iso639-3/oci",
      "modified": "2010-10-25T18:16:38+02:00",
      "publishers": [ ],
      "contributors": [ ],
      "mediaArray": [ ]
    },
    {
        "id": "crdo-09-DUN_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-DUN_SOUND",
        "title": "ALLOc : Dun : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:18:23+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-LABASTIDE-DE-LORDAT_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-LABASTIDE-DE-LORDAT_SOUND",
        "title": "ALLOc : La Bastide-de-Lordat : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:20:08+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-LOUBENS_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-LOUBENS_SOUND",
        "title": "ALLOc : Loubens : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:21:23+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-MERENS-LES-VALS_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-MERENS-LES-VALS_SOUND",
        "title": "ALLOc : Mérens-les-Vals : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:22:24+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-MONTSEGUR_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-MONTSEGUR_SOUND",
        "title": "ALLOc : Montségur : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:23:14+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-PRAYOLS_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-PRAYOLS_SOUND",
        "title": "ALLOc : Prayols : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:24:06+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-QUERIGUT_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-QUERIGUT_SOUND",
        "title": "ALLOc : Quérigut : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:24:56+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-SIGUER_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-SIGUER_SOUND",
        "title": "ALLOc : Siguer : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:25:51+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-ST-MARTIN-D-OYDES_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-ST-MARTIN-D-OYDES_SOUND",
        "title": "ALLOc : Saint-Martin-d'Oydes : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:26:22+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-09-SURBA_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-SURBA_SOUND",
        "title": "ALLOc : Surba : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:26:42+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-11-GRAMAZIE_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-11-GRAMAZIE_SOUND",
        "title": "ALLOc : Gramazie : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:27:39+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-11-MOLLEVILLE_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-11-MOLLEVILLE_SOUND",
        "title": "ALLOc : Molleville : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:28:06+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-11-PUIVERT_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-11-PUIVERT_SOUND",
        "title": "ALLOc : Puivert : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:28:40+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    },
    {
        "id": "crdo-11-RIBOUISSE_SOUND",
        "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-11-RIBOUISSE_SOUND",
        "title": "ALLOc : Ribouisse : Parabole",
        "language": "http://lexvo.org/id/iso639-3/oci",
        "modified": "2010-10-25T18:29:32+02:00",
        "publishers": [ ],
        "contributors": [ ],
        "mediaArray": [ ]
    }
  ]
});

export default Document;
