import Ember from 'ember';
import layout from '../templates/components/doc-created';

export default Ember.Component.extend({
  layout: layout,
  tagName: 'span',
  value: null,
  formatDate: function (dateStr, dateParsed) {
    if (!dateStr) {
      return Ember.String.htmlSafe('');
    }
    if (/^\d{4}$/.test(dateStr)) {
      return Ember.String.htmlSafe(dateStr);
    }

    const date = dateParsed || new Date(dateStr);

    if (isNaN(date.getTime())) {
      return Ember.String.htmlSafe('Date inconnue');
    }

    if (/^\d{4}-\d{2}$/.test(dateStr)) {
      return Ember.String.htmlSafe((date.getMonth() + 1) + '-' + date.getFullYear());
    }

    return Ember.String.htmlSafe(date.getDate() + '-' + (date.getMonth() + 1) + '-' + date.getFullYear());
  },
  shortDateDate: Ember.computed('value', function () {
    return this.formatDate(this.get('value'));
  }),
  periodMatches: Ember.computed('value', function () {
    let dateStr = this.get('value');

    if (!dateStr) {
      return null;
    }
    dateStr = dateStr.trim();

    const m = dateStr.match(/^(\d{4})-(\d{4})$/) ||
      dateStr.match(/^start\s*=\s*([^\s]+)\s*;\s*end\s*=\s*([^\s]+)$/) ||
      dateStr.match(/^end\s*=\s*([^\s]+)\s*;\s*start\s*=\s*([^\s]+)$/);

    if (!m) {
      return null;
    }

    const [, dateStr1, dateStr2] = m;
    let date1 = new Date(dateStr1);
    let date2 = new Date(dateStr2);

    if (isNaN(date1.getTime()) || isNaN(date2.getTime())) {
      return null;
    }
    if (date2 < date1) {
      [date1, date2] = [date2, date1];
    }

    return {
      start: {str: dateStr1, date: date1},
      end: {str: dateStr2, date: date2}
    };

  }),
  isPeriod: Ember.computed('periodMatches', function () {
    const periodMatches = this.get('periodMatches');

    return Boolean(periodMatches);
  }),
  shortDateStart: Ember.computed('periodMatches', function () {
    const periodMatches = this.get('periodMatches');

    if (!periodMatches) {
      return null;
    }

    // from the periodMatches function we know that we have a valid start date
    return this.formatDate(periodMatches.start.str, periodMatches.start.date);

  }),
  shortDateEnd: Ember.computed('periodMatches', function () {
    const periodMatches = this.get('periodMatches');

    if (!periodMatches) {
      return null;
    }

    // from the periodMatches function we know that we have a valid end date
    return this.formatDate(periodMatches.end.str, periodMatches.end.date);

  })


});
