import Ember from 'ember';

export default Ember.Component.extend({
  tagName: "tr",
  viafId: null,
  initialViafId: null,
  actions: {
    addNewContributor: function() {
      if(!this.get('valuesNotSet')) {
        this.get('onAdd')(this.getProperties('name','url','role'));
        this.clearProperties();
      }
    }
  },
  clearProperties: function() {
    var contribDef = {
      viafId: null,
      role:'',
    };
    this.setProperties(contribDef);
    //clear typeahead
    this.$('.aupac-typeahead').typeahead('val','');
  },

  _clearAfterRender: function() {
    Ember.run.schedule('afterRender', this, function () {
      this.clearProperties();
    });
  }.on('init'),

  valuesNotSet: Ember.computed('name','url','role', function() {
    return !(this.get('name') || this.get('url') || this.get('role'));
  }),

  name: Ember.computed('viafId', function() {
    var viafId = this.get('viafId');
    return (viafId == null)?"":viafId.value;
  }),

  url: Ember.computed('viafId', function() {
    var viafId = this.get('viafId');
    return (viafId == null)?"":viafId.url;
  }),

  urlPresent: Ember.computed.bool('url'),

});
