<?php

use Mockery as m;

use EasyRdf\Resource;
use EasyRdf\Literal;

/**
 *
 */
class ThemeControllerTest extends TestCase {

    private $sparqlClient;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->sparqlClient = m::mock('CorpusParole\Libraries\Sparql\SparqlClient');
        $this->app->instance('CorpusParole\Libraries\Sparql\SparqlClient', $this->sparqlClient);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndexQuery() {

        $query = preg_replace('/\s+/', ' ', "select (?o as ?theme) (COUNT(?s) as ?count) where {
                    ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO> .
                    ?s <http://purl.org/dc/elements/1.1/subject> ?o .
                    FILTER (isIRI(?o) && regex(str(?o), '^".config('corpusparole.bnf_ark_base_url')."')) .
                }
                GROUP BY ?o
                ORDER BY DESC(?count)");

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([]));
        $this->get('/api/v1/themes/');
    }

    public function testIndexQueryBnf() {

        $query = preg_replace('/\s+/', ' ', "select (?o as ?theme) (COUNT(?s) as ?count) where {
                    ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO> .
                    ?s <http://purl.org/dc/elements/1.1/subject> ?o .
                    FILTER (isIRI(?o) && regex(str(?o), '^".config('corpusparole.bnf_ark_base_url')."')) .
                }
                GROUP BY ?o
                ORDER BY DESC(?count)");

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([]));
        $this->get('/api/v1/themes/?filter=bnf');
    }


    public function testIndexQueryAll() {

        $query = preg_replace('/\s+/', ' ', "select (?o as ?theme) (COUNT(?s) as ?count) where {
                    ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO> .
                    ?s <http://purl.org/dc/elements/1.1/subject> ?o .
                }
                GROUP BY ?o
                ORDER BY DESC(?count)");

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([]));
        $this->get('/api/v1/themes/?filter=all');
    }


    public function testIndexQueryNone() {

        $query = preg_replace('/\s+/', ' ', "select (?o as ?theme) (COUNT(?s) as ?count) where {
                    ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO> .
                    ?s <http://purl.org/dc/elements/1.1/subject> ?o .
                }
                GROUP BY ?o
                ORDER BY DESC(?count)");

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([]));
        $this->get('/api/v1/themes/?filter=none');
    }


    public function testIndexQueryEmpty() {

        $query = preg_replace('/\s+/', ' ', "select (?o as ?theme) (COUNT(?s) as ?count) where {
                ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO> .
                ?s <http://purl.org/dc/elements/1.1/subject> ?o .
            }
            GROUP BY ?o
            ORDER BY DESC(?count)");

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([]));
        $this->get('/api/v1/themes/?filter=');
    }

    public function testIndexQueryUri() {

        $query = preg_replace('/\s+/', ' ', "select (?o as ?theme) (COUNT(?s) as ?count) where {
                ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO> .
                ?s <http://purl.org/dc/elements/1.1/subject> ?o .
                FILTER isIRI(?o) .
            }
            GROUP BY ?o
            ORDER BY DESC(?count)");

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([]));
        $this->get('/api/v1/themes/?filter=uri');
    }


    public function testIndex() {

        $this->sparqlClient
            ->shouldReceive('query')
            ->once()
            ->andReturn(new \ArrayIterator([
                (object)['theme'=>new Resource('http://lexvo.org/id/iso639-3/gsw'), 'count' => Literal::create(44)],
                (object)['theme'=>new Resource('http://ark.bnf.fr/ark:/12148/cb119339867'), 'count' => Literal::create(33)],
                (object)['theme'=>Literal::create('Français', 'fr'), 'count' => Literal::create(22)],
            ]));
        $this->get('/api/v1/themes/')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["themes" => [
            "http://lexvo.org/id/iso639-3/gsw" => ["label" => "alémanique", "count" => 44],
            "http://ark.bnf.fr/ark:/12148/cb119339867" => ["label" => "famille", "count" => 33],
            "Français" => ["label" => "Français", "count" => 22],
        ]]);
    }
}
