<?php
/* Define $root as a global variable */
global $root;
global $language;
$theme_root = base_path() . path_to_theme();
$root = base_path() . drupal_get_path('theme', 'corpusdelaparole');

$theme_name = 'corpusdelaparole';

/**
 * Preprocess du html
 * @param type $variables
 */
function corpusedelaparole_preprocess_html(&$variables){
  
    $font_open_sans = array(
        '#tag' => 'link',
        '#weight' => 1,
        '#attributes' => array(
            'href' => 'https://fonts.googleapis.com/css?family=Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic&subset=latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic',
            'rel' => 'stylesheet',
            'type' => 'text/css',
        ),
    );

    drupal_add_html_head($font_open_sans, 'google_font_open_sans');
    
}

/**
 * Preprocess de la page
 * @param string $variables
 */
function corpusdelaparole_preprocess_page(&$variables) {
  // Forçage du breadcrumb sur homepage
  if(drupal_is_front_page()){  
  // Building breadcrumbs
    $breadcrumb = array();
    $breadcrumb[] = l('Home', '<front>');
    //$breadcrumb[] = l('Shoes', 'shoes');
    drupal_set_breadcrumb($breadcrumb);
  }
  
  if(bootstrap_setting('fluid_container') == 1) {
    $variables['container_class'] = 'container-fluid container-non-responsive';
  }
  else {
    $variables['container_class'] = 'container container-non-responsive';
  }
  
}

/**
 * Implements hook_menu_link().
 */
function corpusdelaparole_menu_link(array $variables) {
  $element = $variables['element'];
  $sub_menu = '';
  if ($element['#below']) {
    // Prevent dropdown functions from being added to management menu so it
    // does not affect the navbar module.
    if (($element['#original_link']['menu_name'] == 'management') && (module_exists('navbar'))) {
      $sub_menu = drupal_render($element['#below']);
    }
    elseif ((!empty($element['#original_link']['depth'])) && ($element['#original_link']['depth'] == 1)) {
      // Add our own wrapper.
      unset($element['#below']['#theme_wrappers']);
      $sub_menu = '<ul class="dropdown-menu">' . drupal_render($element['#below']) . '</ul>';
      // Generate as standard dropdown.
      $element['#title'] .= ' <span class="caret"></span>';
      $element['#attributes']['class'][] = 'dropdown';
      $element['#localized_options']['html'] = TRUE;

      // Set dropdown trigger element to # to prevent inadvertant page loading
      // when a submenu link is clicked.
      $element['#localized_options']['attributes']['data-target'] = '#';            
      $element['#localized_options']['attributes']['class'][] = 'dropdown-toggle disabled';
      $element['#localized_options']['attributes']['data-toggle'] = 'dropdown';
    }
  }
  
  
  /* Ajoute correctement de l'ancre dans l'URL pour l'app de l'IRI  */
  if(strpos($element['#href'], '#') === false){
    //
  } else {    
    if($element['#original_link']['menu_name'] == 'main-menu'){
      $split = explode('#',  $element['#href']);
      $element['#href'] = $split[0];
      $element['#localized_options']['fragment'] = $split[1];
      $element['#localized_options']['attributes']['class'][] = 'corpus-app-menu';

    }    
  }
  
  if($element['#original_link']['menu_name'] == 'main-menu'){    
//    dpm($element);
  }
  
  // On primary navigation menu, class 'active' is not set on active menu item.
  // @see https://drupal.org/node/1896674
  if (($element['#href'] == $_GET['q'] || ($element['#href'] == '<front>' && drupal_is_front_page())) && (empty($element['#localized_options']['language']))) {
    if(empty($element['#localized_options']['fragment'])){  
      $element['#attributes']['class'][] = 'active';
    }
  }
  
  $output = l($element['#title'], $element['#href'], $element['#localized_options']);
  
  return '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>\n";
}


/**
 * Modification du menu du footer
 */
function corpusdelaparole_menu_tree__menu_footer_menu(&$variables) {
  $return  = '<div class="row">';
  $return .= '  <div class="col-md-12">';
  $return .= '    <ul id="footer_menu" class="menu nav">';
  $return .=        $variables['tree'];
  $return .= '      <li>';
  $return .= '        '.l(t('Plan du site'), '/sitemap');
  $return .= '      </li>';
  $return .= '    </ul>';
  $return .= '  </div>';
//  $return .= '  <div class="col-sm-12 col-md-4">';
//  $return .= '    &copy;&nbsp;'.t('Ministère de la culture et de la communication').'';
//  $return .= '  </div>';
  $return .= '</div>';
  return $return;
}


/**
 * Implements hook_preprocess_views_view().
 */
function corpusdelaparole_preprocess_views_view(&$vars) {
  if ($vars['name'] == 'langues_isotope') {
    drupal_add_css(drupal_get_path('theme', 'corpusdelaparole') . '/css/langues_isotope.css');
    drupal_add_js(drupal_get_path('theme', 'corpusdelaparole') . '/js/langues_isotope.js');
  }
}