<?php
/**
 * @file
 * corpus_structures_et_contenus.features.inc
 */

/**
 * Implements hook_ctools_plugin_api().
 */
function corpus_structures_et_contenus_ctools_plugin_api($module = NULL, $api = NULL) {
  if ($module == "context" && $api == "context") {
    return array("version" => "3");
  }
  if ($module == "ds" && $api == "ds") {
    return array("version" => "1");
  }
  if ($module == "page_manager" && $api == "pages_default") {
    return array("version" => "1");
  }
  if ($module == "strongarm" && $api == "strongarm") {
    return array("version" => "1");
  }
}

/**
 * Implements hook_views_api().
 */
function corpus_structures_et_contenus_views_api($module = NULL, $api = NULL) {
  return array("api" => "3.0");
}

/**
 * Implements hook_fe_nodequeue_export_fields().
 */
function corpus_structures_et_contenus_fe_nodequeue_export_fields() {
  $nodequeues = array();

  // Exported nodequeues: image_grid_queue
  $nodequeues['image_grid_queue'] = array(
    'name' => 'image_grid_queue',
    'title' => 'image grid queue',
    'subqueue_title' => '',
    'size' => 0,
    'link' => '',
    'link_remove' => '',
    'owner' => 'nodequeue',
    'show_in_ui' => 1,
    'show_in_tab' => 1,
    'show_in_links' => 0,
    'reference' => 0,
    'reverse' => 0,
    'insert_at_front' => 0,
    'i18n' => 0,
    'subqueues' => 1,
    'types' => array(
      0 => 'bloc_images_grid',
    ),
    'roles' => array(),
    'count' => 0,
  );

  return $nodequeues;
}

/**
 * Implements hook_image_default_styles().
 */
function corpus_structures_et_contenus_image_default_styles() {
  $styles = array();

  // Exported image style: block_images_grid.
  $styles['block_images_grid'] = array(
    'label' => 'block images grid',
    'effects' => array(
      1 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 660,
          'height' => 495,
        ),
        'weight' => 1,
      ),
    ),
  );

  // Exported image style: block_images_grid_carto.
  $styles['block_images_grid_carto'] = array(
    'label' => 'block images grid carto',
    'effects' => array(
      2 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 690,
          'height' => 495,
        ),
        'weight' => 1,
      ),
    ),
  );

  // Exported image style: langues_isotope.
  $styles['langues_isotope'] = array(
    'label' => 'langues isotope',
    'effects' => array(
      3 => array(
        'name' => 'image_scale_and_crop',
        'data' => array(
          'width' => 257,
          'height' => 180,
        ),
        'weight' => 1,
      ),
    ),
  );

  return $styles;
}

/**
 * Implements hook_node_info().
 */
function corpus_structures_et_contenus_node_info() {
  $items = array(
    'langues' => array(
      'name' => t('Langues'),
      'base' => 'node_content',
      'description' => t('Les Langues  présentées dans la rubrique "langue" du site Corpus de la Parole'),
      'has_title' => '1',
      'title_label' => t('Titre'),
      'help' => '',
    ),
  );
  drupal_alter('node_info', $items);
  return $items;
}
