/* jshint node:true */
/* eslint-env node */
/* eslint global-require: 0, no-magic-numbers: 0 */

module.exports = function(app) {
  const express = require('express');
  const _ = require('lodash');

  const v1LexvoRouter = express.Router();

  const lexvoMappings = require('../fixtures/lexvo');

  v1LexvoRouter.get('/:id', function(req, res) {
    const idList = req.params.id.split(',');

    res.send({
      lexvoids: _.reduce(idList, function(r, id) {
        r[id] = (id in lexvoMappings) ? lexvoMappings[id] : null;

        return r;
      }, {})
    });
  });

  app.use('/api/v1/resolvers/lexvo', v1LexvoRouter);
};
