/* eslint-disable no-magic-numbers, no-ternary */

import * as constants from 'corpus-common-addon/utils/constants';
import _ from 'lodash/lodash';

export function isLexvoLink(s) {
  return s && typeof s === 'string' && s.startsWith(constants.LEXVO_BASE_URL);
}

export function isBnfLink(s) {
  return s &&
    typeof s === 'string' &&
    (s.startsWith(constants.BNF_BASE_URL) ||
    s.startsWith(constants.BNF_ARK_BASE_URL) ||
    s.startsWith(constants.BNF_ARK_BASE_ID));
}

export function isArkBnfLink(s) {
  return s &&
    typeof s === 'string' &&
    (s.startsWith(constants.BNF_BASE_URL + constants.BNF_ARK_BASE_ID) ||
    s.startsWith(constants.BNF_ARK_BASE_URL + constants.BNF_ARK_BASE_ID));
}

export function isGeonamesLink(s) {
  return (typeof s === 'string') && (s.match(constants.GEONAMES_BASE_URLS) !== null);
}

export function getGeonamesCode(s) {
  const m = s.match(constants.GEONAMES_BASE_URLS);
  let code = s;

  if (m) {
    code = s.slice(m[0].length);
  }

  return code.replace(/\/+$/, '');
}

export function isViafLink(s) {
  return (typeof s === 'string') && (s.match(constants.VIAF_URL_REGEXP) !== null);
}

export function getViafCode(s) {
  const m = s.match(constants.VIAF_URL_REGEXP);
  let code = s;

  if (m) {
    code = s.slice(m[0].length);
  }

  return code.replace(/\/+$/, '');
}

export function switchArkBnfLink(s) {
  if (!s) {
    return s;
  }
  if (typeof s === 'string' && s.startsWith(constants.BNF_BASE_URL + constants.BNF_ARK_BASE_ID)) {
    return constants.BNF_ARK_BASE_URL + s.slice(constants.BNF_BASE_URL.length);
  } else if (typeof s === 'string' && s.startsWith(constants.BNF_ARK_BASE_URL + constants.BNF_ARK_BASE_ID)) {
    return constants.BNF_BASE_URL + s.slice(constants.BNF_ARK_BASE_URL.length);
  }

  return s;
}

export function calculateBnfArkControlChar(id) {
  if (!id) {
    return null;
  }
  const sum = _.reduce(id, function (s, c, i) {
    return s + (i + 1) * (c in constants.NOID_CHARS_POS ? constants.NOID_CHARS_POS[c] : 0);
  }, 0);

  return constants.NOID_CHARS[sum % constants.NOID_CHARS.length];
}

export function getOLACBaseUrl(literalVal) {
  let olacRes = null;

  if (!literalVal) {
    return null;
  }
  if (typeof literalVal !== 'object') {
    return null;
  }
  const datatype = literalVal.datatype;

  if (!datatype) {
    return null;
  }

  _.forEach(constants.OLAC_BASE_URL, function (olacDef, urlPrefix) {
    if (_.startsWith(datatype, urlPrefix)) {
      olacRes = olacDef;

      return false; // we found it, we exit early
    }

    return true;
  });

  return olacRes;
}

export function isOLACLiteral(literalDef) {
  const olacDef = getOLACBaseUrl(literalDef);

  return Boolean(olacDef);
}

export function isDCMILink(s) {
  return s && typeof s === 'string' && s.startsWith(constants.DCMI_BASE_URL);
}

export function getPeriodMatches(periodStr) {

  let dateStr = periodStr;

  if (!dateStr) {
    return null;
  }
  dateStr = dateStr.trim();

  const m = dateStr.match(/^(\d{4})-(\d{4})$/) ||
    dateStr.match(/^start\s*=\s*([^\s]+)\s*;\s*end\s*=\s*([^\s]+)$/) ||
    dateStr.match(/^end\s*=\s*([^\s]+)\s*;\s*start\s*=\s*([^\s]+)$/);

  if (!m) {
    return null;
  }

  const [, dateStr1, dateStr2] = m;
  let date1 = new Date(dateStr1);
  let date2 = new Date(dateStr2);

  if (isNaN(date1.getTime()) || isNaN(date2.getTime())) {
    return null;
  }
  if (date2 < date1) {
    [date1, date2] = [date2, date1];
  }

  return {
    start: {str: dateStr1, date: date1},
    end: {str: dateStr2, date: date2}
  };

}
