import Ember from 'ember';

export default Ember.Component.extend({

    player: Ember.inject.service(),

    classNames: ['notice-component'],

    item: Ember.computed('model', 'player.model', function() {
        return this.get('model') || this.get('player').get('model');
    }),

    participants: Ember.computed('item.contributors', function() {
        var participants = [];
        if(this.get('item')) {
            this.get('item').get('contributors').forEach(function(contributor) {
                if(contributor.name) {
                    participants.push({ name: contributor.name, role: contributor.role.split('/').pop() });
                }
            });
        }
        return participants;
    }),

    location: Ember.computed('item.geoInfo', function() {
        var location = '';
        if(this.get('item')) {
            var meta = this.get('item').get('geoInfo').notes.find(element => element.lang);
            if(meta) {
                location = meta.value;
            }
        }
        return location;
    }),

    actions: {

        close: function() {
            this.set('model', null);
        }

    }

});
