<?php

use CorpusParole\Models\GeoResource;
use CorpusParole\Libraries\CocoonUtils;

/**
 *
 */
class GeoResourceTest extends TestCase {

    const TEST_DOCS = [
        "LOC1" => <<<EOT
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix sesame: <http://www.openrdf.org/schema/sesame#> .
    @prefix owl: <http://www.w3.org/2002/07/owl#> .
    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
    @prefix fn: <http://www.w3.org/2005/xpath-functions#> .

    <%1\$scrdo-CFPP2000_35_SOUND> a <http://www.openarchives.org/ore/terms/Aggregation> ;
        <http://www.europeana.eu/schemas/edm/aggregatedCHO> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-CFPP2000_35_SOUND> ;
        <http://www.europeana.eu/schemas/edm/dataProvider> "Langage et langues : description, théorisation, transmission" ;
        <http://www.europeana.eu/schemas/edm/hasView> <http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml> , <http://cocoon.huma-num.fr/data/cfpp2000/Ozgur_Kilic_H_32_alii_3e-2.mp3> , <http://cocoon.huma-num.fr/data/cfpp2000/Ozgur_Kilic_H_32_alii_3e-2.wav> ;
        <http://www.europeana.eu/schemas/edm/isShownAt> <http://corpusdelaparole.huma-num.fr/corpus-app#/detail/crdo-CFPP2000_35_SOUND> ;
        <http://www.europeana.eu/schemas/edm/isShownBy> <http://cocoon.huma-num.fr/data/archi/masters/372593.wav> ;
        <http://www.europeana.eu/schemas/edm/provider> "Corpus de la Parole"@fr ;
        <http://www.europeana.eu/schemas/edm/rights> <http://creativecommons.org/licenses/by-nc-sa/4.0/> .

    <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-CFPP2000_35_SOUND> a <http://www.europeana.eu/schemas/edm/ProvidedCHO> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/extent> "PT48M26S" ;
        <http://purl.org/dc/terms/issued> "2013-10-12T14:35:57+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
        <http://purl.org/dc/elements/1.1/contributor> <http://viaf.org/viaf/93752300> , "Tanguy, Noalig" , "Chevrier, Michel" , "Kiliç, Ozgur" , "Salvegas, Etienne" , "du-Breuil-de-Pont-en-Auge, Augustin" , "du-Breuil-de-Pont-en-Auge, Benoît" ;
        <http://purl.org/dc/elements/1.1/description> "Enregistrement issu du Corpus de Français Parlé Parisien des années 2000 (CFPP2000)"@fr , "Quartier(s) concerné(s) : Paris 3e, et 20e (pour l'âge adulte); Anonymisation : Noalig TANGUY;"@fr ;
        <http://purl.org/dc/elements/1.1/identifier> "ark:/87895/1.17-375004" , "%2\$scrdo-CFPP2000_35_SOUNDid" , "oai:crdo.vjf.cnrs.fr:crdo-CFPP2000_35" , "Cote producteur: [03-01] Ozgur_Kilic_H_32_alii_3e"@fr , "ark:/87895/1.17-372593" , "oai:crdo.vjf.cnrs.fr:crdo-CFPP2000_35_SOUND" ;
        <http://purl.org/dc/elements/1.1/language> <http://lexvo.org/id/iso639-3/fra> ;
        <http://purl.org/dc/elements/1.1/publisher> <http://viaf.org/viaf/142432638>;
        <http://purl.org/dc/elements/1.1/subject> <http://ark.bnf.fr/ark:/12148/cb13318415c> , "anthropological_linguistics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "lexicography"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "phonetics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , <http://lexvo.org/id/iso639-3/fra> , <http://ark.bnf.fr/ark:/12148/cb133188907> , <http://ark.bnf.fr/ark:/12148/cb11932762f> , "general_linguistics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , <http://ark.bnf.fr/ark:/12148/cb133183660> , "text_and_corpus_linguistics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "Français"@fr , <http://ark.bnf.fr/ark:/12148/cb122368540> , "phonology"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "semantics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "sociolinguistics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "syntax"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "typology"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , <http://ark.bnf.fr/ark:/12148/cb119418302> , <http://ark.bnf.fr/ark:/12148/cb135540729> , "discourse_analysis"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "historical_linguistics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , "language_documentation"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , <http://ark.bnf.fr/ark:/12148/cb133192210> , <http://ark.bnf.fr/ark:/12148/cb119377452> , <http://ark.bnf.fr/ark:/12148/cb13320451h> , <http://ark.bnf.fr/ark:/12148/cb13318422n> , <http://ark.bnf.fr/ark:/12148/cb11975823c> , "mathematical_linguistics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> ;
        <http://purl.org/dc/elements/1.1/title> "Entretien de Ozgur Kiliç 2"@fr ;
        <http://purl.org/dc/elements/1.1/type> <http://ark.bnf.fr/ark:/12148/cb11932135w> , <http://ark.bnf.fr/ark:/12148/cb12481481z> , <http://purl.org/dc/dcmitype/Sound> , "primary_text"^^<http://www.language-archives.org/OLAC/1.1/linguistic-type> , <http://purl.org/dc/dcmitype/Text> , "narrative"^^<http://www.language-archives.org/OLAC/1.1/discourse-type> , "report"^^<http://www.language-archives.org/OLAC/1.1/discourse-type> , "unintelligible_speech"^^<http://www.language-archives.org/OLAC/1.1/discourse-type> ;
        <http://purl.org/dc/terms/available> "2013-10-12"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/spatial> [
            a <http://www.europeana.eu/schemas/edm/Place> ;
            owl:sameAs <http://sws.geonames.org/6618626/> ;
            <http://www.w3.org/2004/02/skos/core#note> "FR"^^<http://purl.org/dc/terms/ISO3166> , "France, Île-de-France, Paris, Université Sorbonne Nouvelle Paris 3, site Censier"@fr , "Domicile de Ozgur Kiliç"@fr , "France, Île-de-France, Paris 20"@fr
        ];
        <http://www.europeana.eu/schemas/edm/isGatheredInto> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE> , <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_CFPP2000> ;
        <http://www.language-archives.org/OLAC/1.1/depositor> <http://viaf.org/viaf/93752300> ;
        <http://www.language-archives.org/OLAC/1.1/interviewer> <http://viaf.org/viaf/93752300> ;
        <http://www.language-archives.org/OLAC/1.1/transcriber> "Tanguy, Noalig" ;
        <http://purl.org/dc/elements/1.1/coverage> "Quartier concerné : 3e"@fr ;
        <http://www.language-archives.org/OLAC/1.1/responder> "Chevrier, Michel" , "Kiliç, Ozgur" , "Salvegas, Etienne" , "du-Breuil-de-Pont-en-Auge, Augustin" , "du-Breuil-de-Pont-en-Auge, Benoît" ;
        <http://purl.org/dc/elements/1.1/relation> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-CFPP2000_31_SOUND> .


    <http://cocoon.huma-num.fr/exist/crdo/cfpp2000/fra/Ozgur_Kilic_H_32_alii_3e-2.xml> a <http://www.europeana.eu/schemas/edm/WebResource> ;
        <http://purl.org/dc/elements/1.1/format> "application/xml"^^<http://purl.org/dc/terms/IMT> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/issued> "2013-11-04T22:20:07+01:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
        <http://purl.org/dc/terms/conformsTo> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_transcriber> .

    <http://cocoon.huma-num.fr/data/archi/masters/372593.wav> a <http://www.europeana.eu/schemas/edm/WebResource> ;
        <http://purl.org/dc/elements/1.1/format> "audio/x-wav"^^<http://purl.org/dc/terms/IMT> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/extent> "PT48M26S" ;
        <http://purl.org/dc/terms/issued> "2013-10-12T14:35:57+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> .

    <http://cocoon.huma-num.fr/data/cfpp2000/Ozgur_Kilic_H_32_alii_3e-2.mp3> a <http://www.europeana.eu/schemas/edm/WebResource> ;
        <http://purl.org/dc/elements/1.1/format> "audio/mpeg"^^<http://purl.org/dc/terms/IMT> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/extent> "PT48M26S" ;
        <http://purl.org/dc/terms/issued> "2013-10-12T14:35:57+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
        <http://www.europeana.eu/schemas/edm/isDerivativeOf> <http://cocoon.huma-num.fr/data/archi/masters/372593.wav> .

    <http://cocoon.huma-num.fr/data/cfpp2000/Ozgur_Kilic_H_32_alii_3e-2.wav> a <http://www.europeana.eu/schemas/edm/WebResource> ;
        <http://purl.org/dc/elements/1.1/format> "audio/x-wav"^^<http://purl.org/dc/terms/IMT> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/extent> "PT48M26S" ;
        <http://purl.org/dc/terms/issued> "2013-10-12T14:35:57+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
        <http://www.europeana.eu/schemas/edm/isDerivativeOf> <http://cocoon.huma-num.fr/data/archi/masters/372593.wav> .
EOT
        ,
        "LOC2" => <<<EOT
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix sesame: <http://www.openrdf.org/schema/sesame#> .
    @prefix owl: <http://www.w3.org/2002/07/owl#> .
    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
    @prefix fn: <http://www.w3.org/2005/xpath-functions#> .

    <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-CFPP2000_35_SOUND> a <http://www.europeana.eu/schemas/edm/ProvidedCHO> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/extent> "PT48M26S" ;
        <http://purl.org/dc/terms/issued> "2013-10-12T14:35:57+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
        <http://purl.org/dc/elements/1.1/description> "Enregistrement issu du Corpus de Français Parlé Parisien des années 2000 (CFPP2000)"@fr , "Quartier(s) concerné(s) : Paris 3e, et 20e (pour l'âge adulte); Anonymisation : Noalig TANGUY;"@fr ;
        <http://purl.org/dc/elements/1.1/identifier> "ark:/87895/1.17-375004" , "%2\$scrdo-CFPP2000_35_SOUNDid" , "oai:crdo.vjf.cnrs.fr:crdo-CFPP2000_35" , "Cote producteur: [03-01] Ozgur_Kilic_H_32_alii_3e"@fr , "ark:/87895/1.17-372593" , "oai:crdo.vjf.cnrs.fr:crdo-CFPP2000_35_SOUND" ;
        <http://purl.org/dc/elements/1.1/language> <http://lexvo.org/id/iso639-3/fra> ;
        <http://purl.org/dc/elements/1.1/publisher> <http://viaf.org/viaf/142432638>;
        <http://purl.org/dc/elements/1.1/title> "Entretien de Ozgur Kiliç 2"@fr ;
        <http://purl.org/dc/terms/available> "2013-10-12"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/spatial> [
            a <http://www.europeana.eu/schemas/edm/Place> ;
            <http://www.w3.org/2004/02/skos/core#note> "FR"^^<http://purl.org/dc/terms/ISO3166> , "France, Île-de-France, Paris, Université Sorbonne Nouvelle Paris 3, site Censier"@fr , "Domicile de Ozgur Kiliç"@fr , "France, Île-de-France, Paris 20"@fr
        ] .
EOT
        ,
        "LOC3" => <<<EOT
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix sesame: <http://www.openrdf.org/schema/sesame#> .
    @prefix owl: <http://www.w3.org/2002/07/owl#> .
    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
    @prefix fn: <http://www.w3.org/2005/xpath-functions#> .

    <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-CFPP2000_35_SOUND> a <http://www.europeana.eu/schemas/edm/ProvidedCHO> ;
        <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
        <http://purl.org/dc/terms/created> "2010-11-17"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/extent> "PT48M26S" ;
        <http://purl.org/dc/terms/issued> "2013-10-12T14:35:57+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
        <http://purl.org/dc/elements/1.1/description> "Enregistrement issu du Corpus de Français Parlé Parisien des années 2000 (CFPP2000)"@fr , "Quartier(s) concerné(s) : Paris 3e, et 20e (pour l'âge adulte); Anonymisation : Noalig TANGUY;"@fr ;
        <http://purl.org/dc/elements/1.1/identifier> "ark:/87895/1.17-375004" , "%2\$scrdo-CFPP2000_35_SOUNDid" , "oai:crdo.vjf.cnrs.fr:crdo-CFPP2000_35" , "Cote producteur: [03-01] Ozgur_Kilic_H_32_alii_3e"@fr , "ark:/87895/1.17-372593" , "oai:crdo.vjf.cnrs.fr:crdo-CFPP2000_35_SOUND" ;
        <http://purl.org/dc/elements/1.1/language> <http://lexvo.org/id/iso639-3/fra> ;
        <http://purl.org/dc/elements/1.1/publisher> <http://viaf.org/viaf/142432638>;
        <http://purl.org/dc/elements/1.1/title> "Entretien de Ozgur Kiliç 2"@fr ;
        <http://purl.org/dc/terms/available> "2013-10-12"^^<http://purl.org/dc/terms/W3CDTF> ;
        <http://purl.org/dc/terms/spatial> [
            a <http://www.europeana.eu/schemas/edm/Place> ;
            owl:sameAs <http://sws.geonames.org/6618626/> ;
            owl:sameAs <http://fr.dbpedia.org/resource/Gramazie> ;
            <http://www.w3.org/2004/02/skos/core#note> "FR"^^<http://purl.org/dc/terms/ISO3166> , "France, Île-de-France, Paris, Université Sorbonne Nouvelle Paris 3, site Censier"@fr , "Domicile de Ozgur Kiliç"@fr , "France, Île-de-France, Paris 20"@fr
        ] .
EOT
    ];

    public function setUp() {

        parent::setup();
        $this->graphs = [];
        $this->graphUrl = sprintf("%1\$scrdo-CFPP2000_35_SOUND", config('corpusparole.corpus_doc_id_base_uri'));
        foreach(self::TEST_DOCS as $k => $ttl) {

            $this->graphs[$k] = new EasyRdf\Graph($this->graphUrl, sprintf($ttl, config('corpusparole.corpus_doc_id_base_uri'), config('corpusparole.corpus_id_scheme')));
        }
    }

    public function getGeoResource($key) {

        $graph = $this->graphs[$key];
        $places = $graph->allOfType("<http://www.europeana.eu/schemas/edm/Place>");
        assert(count($places)>0);
        $place = $places[0];

        return new GeoResource($place->getUri(), $graph);

    }

    public function testConstructor() {

        $this->assertNotNull($this->graphs, 'Graphs shoud not be null');

        $geoResource = $this->getGeoResource("LOC1");

        $this->assertNotNull($geoResource);
    }

    public function testGetRefLoc() {
        $geoResource = $this->getGeoResource("LOC1");

        $refLoc = $geoResource->getRefLocs();

        $this->assertEquals(['http://sws.geonames.org/6618626/'], $refLoc);

    }

    public function testGetRefLocNull() {
        $geoResource = $this->getGeoResource("LOC2");

        $refLoc = $geoResource->getRefLocs();

        $this->assertEmpty($refLoc);

    }

    public function testGetRefLocMultiple() {
        $geoResource = $this->getGeoResource("LOC3");

        $refLocs = $geoResource->getRefLocs();

        $this->assertTrue(is_array($refLocs));
        $this->assertCount(2,$refLocs);
        $this->assertEquals(['http://sws.geonames.org/6618626/', 'http://fr.dbpedia.org/resource/Gramazie'], $refLocs);


    }

    public function testNotes() {
        $geoResource = $this->getGeoResource("LOC1");

        $notes = $geoResource->getNotes();

        $this->assertTrue(is_array($notes));
        $this->assertCount(4, $notes);

        $this->assertContainsOnlyInstancesOf("EasyRdf\Literal", $notes);

    }


    public function testJsonSerialize() {
        $geoResource = $this->getGeoResource("LOC1");

        $json = $geoResource->jsonSerialize();

        $this->assertEquals(["ref-locs", "notes"], array_keys($json));
        $this->assertEquals(["http://sws.geonames.org/6618626/"], $json['ref-locs']);

        $notes = $json['notes'];
        $this->assertTrue(is_array($notes));
        $this->assertCount(4, $notes);

    }


    public function testJsonSerializeNull() {
        $geoResource = $this->getGeoResource("LOC2");

        $json = $geoResource->jsonSerialize();

        $this->assertEmpty($json['ref-locs']);

    }

    public function testJsonSerializeMultipleRefLocs() {
        $geoResource = $this->getGeoResource("LOC3");

        $json = $geoResource->jsonSerialize();

        $this->assertEquals(["ref-locs", "notes"], array_keys($json));
        $this->assertEquals(["http://sws.geonames.org/6618626/", "http://fr.dbpedia.org/resource/Gramazie"], $json['ref-locs']);

    }


}
