import Ember from 'ember';
import IntervalTree from 'interval-tree';

export default Ember.Component.extend({

    classNames: ['transcript-component'],

    player: Ember.inject.service(),

    autoscrollElement : '.corpus-app-container',
    previousElement: 0,
    autoscroll: true,
    timeout: null,

    hasSections: Ember.computed('player', 'player.transcript', function() {
      var sections = this.get('player.transcript.sections');
      return sections && sections.length > 0;
    }),

    didReceiveAttrs() {
      this._super(...arguments);
      this.set('intervals', new IntervalTree(this.get('player.model.duration_ms')/2));
    },

    itemObserver: Ember.observer('player.item', function () {
      if ( !(this.get('isDestroyed') || this.get('isDestroying')) ) {
          this.set('autoscroll', true);
      }
    }),

    didInsertElement() {
        Ember.$('#' + this.elementId).parent().on('scroll', Ember.run.bind(this, this.onScroll));
    },

    onScroll() {
        if ( !(this.get('isDestroyed') || this.get('isDestroying')) ) {
          this.set('autoscroll', false);
        }
        if(this.elementId) {
          Ember.$('#' + this.elementId).parent().off('scroll');
        }
    },

    scroll: Ember.observer('player.progress', function() {
      var self = this;
      var progress = this.get('player.progress');
      var previousElement = this.get('previousElement');
      if(previousElement && progress >= previousElement.start && progress < previousElement.end) {
        return;
      }
      var intervals = this.get('intervals');
      if(!intervals) {
        return;
      }
      var intervalList = intervals.search(progress);
      if(intervalList.length === 0) {
        return;
      }
      var target = intervalList[0];
      //var target = this.$('.sentence.active');
      if(previousElement) {
        previousElement.object.removeClass('active');
        Ember.$(".fa-play",previousElement.object).show();
      }
      target.object.addClass('active');
      Ember.$(".fa-play",target.object).hide();


      if(this.get('autoscroll') && target.object.length && (!previousElement || target.id !== previousElement.id)) {
          Ember.$('#' + self.elementId).parent().off('scroll');
          Ember.$(this.get('autoscrollElement')).animate({
              scrollTop: target.object.offset().top + Ember.$(this.get('autoscrollElement')).scrollTop() - Ember.$(this.get('autoscrollElement')).offset().top - 154
          }, 150, 'swing', function() {
              setTimeout(function() {
                  Ember.$('#' + self.elementId).parent().on('scroll', Ember.run.bind(self, self.onScroll));
              }, 100);
          });
          this.set('previousElement', target);
      }
    }),


    actions: {

        play: function(progress) {
            this.get('player').trigger('progressupdate', progress);
            this.get('player').set('playing', true);
        }
    }

});
