import Ember from 'ember';

export default Ember.Component.extend({

  hasPlayer: Ember.computed.bool('player'),
  hideSpeaker: Ember.computed.not('annotation.showSpeaker'),

  begin: Ember.computed.readOnly('annotation.begin'),
  end: Ember.computed.readOnly('annotation.end'),
  title: Ember.computed.readOnly('annotation.title'),
  original: Ember.computed.readOnly('annotation.original'),
  speaker: Ember.computed.readOnly('annotation.speaker'),
  showSpeaker: Ember.computed.readOnly('annotation.showSpeaker'),
  literal: Ember.computed.readOnly('annotation.literal'),
  translation: Ember.computed.readOnly('annotation.translation'),

  didInsertElement: function() {
    if(this.get('hasPlayer') && this.get('intervals')) {
      this.get('intervals').add(this.get('begin'), this.get('end'), this.get('elementId'), this.$());
    }
  },


});
