@extends('base')

@section('css-assets')
<link href="{{ asset('/css/vendor/yasqe.min.css')}}" rel='stylesheet' type='text/css'>
<link href="{{ asset('/css/vendor/yasr.min.css')}}" rel='stylesheet' type='text/css'>
@parent
@endsection


@section('nav')
<ul class="nav navbar-nav">
    <li><a href="{{ route('sparql_form') }}">Client SPARQL</a></li>
</ul>
@endsection

@section('js-assets')
@parent
    <script src="{{ asset('/js/vendor/yasqe.bundled.min.js') }}"></script>
    <script src="{{ asset('/js/sparqlclient.js') }}"></script>
    <script>
    $(function() {
        initSparqlEditor();
    });
    </script>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <form action="{{ route('sparql_query') }}" method="get" id="query-form">
            <fieldset>
                <div class="form-group row">
                    <div class="col-md-12">
                    <label for="query">Requête</label><br />
                    <textarea rows="18" cols="80" name="query" id="query" class="form-control">select distinct ?Concept where {[] a ?Concept} LIMIT 100</textarea>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-md-2">
                        <label for="format" class="n control-label">Format du résultat</label>
                        <select name="format" id="format" class="form-control">
                            <option value="text/html" selected="selected">HTML</option>
                        </select>
                    </div>
                    <div class="form-group col-md-2">
                        <label for="limit" class="n control-label">Limite</label>
                        <div class="input-group">
                            <input name="limit" id="limit" class="form-control" type="text" value="{{ config('corpusparole.sparql_client_default_limit') }}" />
                            <div class="input-group-btn">
                                <button id="limit-btn" type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="caret"></span></button>
                                <ul id="limits-choices" class="dropdown-menu dropdown-menu-right">
                                    <li><a href="#">0</a></li>
                                    <li><a href="#">100</a></li>
                                    <li><a href="#">200</a></li>
                                    <li><a href="#">500</a></li>
                                </ul>
                            </div>
                        </div>
                        <span class=" help-block"> résultats/pages <i>(0 = tous sur une seule page)</i></span>
                    </div>
                </div>
                <div class="form-group row">
                    <div class="col-md-12">
                    <input id="submit-query-form" type="submit" class="btn btn-primary" value="Lancer la requête"/>
                    <input type="reset" class="btn" value="Nouvelle requête" id="reset-query"/>
                    </div>
                </div>
            </fieldset>
        </form>
    </div>
</div>

<div class="row">
    <div id="results" class="col-md-12">
</div>
@endsection
