<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;
use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Services\LexvoResolverInterface;
use CorpusParole\Services\LexvoResolverException;

class LexvoController extends Controller
{
    public function __construct(LexvoResolverInterface $lexvoResolver) {
        $this->lexvoResolver = $lexvoResolver;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id od comma separatedlist of ids
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            return response()->json(['lexvoids' => $this->lexvoResolver->getNames(explode(",", $id))]);
        } catch (LexvoResolverException $e) {
            abort(500, $e->getMessage());
        }
    }

}
