import Ember from 'ember';
import AmCharts from 'ammaps';

export default Ember.Component.extend({

    filter: Ember.inject.service(),
    locationObserver: Ember.observer('filter.location', function() {
        if(!this.get('filter').get('location')) {
            this.get('map').selectObject();
        }
    }),

    didInsertElement: function(){
        this.$('#mapdiv').height(Ember.$('.corpus-app-container').height());
        this.createAmMap();
    },

    createAmMap: function() {
        this.set('map', AmCharts.makeChart('mapdiv', {
            'type': 'map',
            'fontFamily': 'sans-serif',
            'fontSize': '12px',
            'dragMap': false,
            'zoomOnDoubleClick': false,
            'language': 'fr',

            'areasSettings': {
                'autoZoom': false,
                'selectable': true,
                'color': '#becfd4',
                'colorOutline': '#253946',
                'selectedColor': '#253946',
                'rollOverOutlineColor': '#253946'
            },

            'zoomControl': {
                'zoomControlEnabled': false,
            },

            'dataProvider': {
                'map': 'continentsLow',
                'areas': [{
                    'id':'south_america',
                    'linkToObject': {
                        'map': 'worldLow',
                        'getAreasFromMap': true
                    },
                    'passZoomValuesToTarget': true,
                    'autoZoom': true
                },
                {
                    'id':'north_america',
                    'linkToObject': {
                        'map': 'worldLow',
                        'getAreasFromMap': true
                    },
                    'passZoomValuesToTarget': true,
                    'autoZoom': true
                },
                {
                    'id':'asia',
                    'linkToObject': {
                        'map': 'worldLow',
                        'getAreasFromMap': true
                    },
                    'passZoomValuesToTarget': true,
                    'autoZoom': true
                },
                {
                    'id':'europe',
                    'linkToObject': {
                        'map': 'worldLow',
                        'getAreasFromMap': true,
                        'areas': [{
                            'id': 'FR',
                            'linkToObject': {
                                'map': 'france2016Low',
                                'getAreasFromMap': true,
                                'areas': [{
                                    'id': 'FR-A',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-B',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-C',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-D',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-E',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-F',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-G',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-H',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-I',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-J',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-K',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-L',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                },
                                {
                                    'id': 'FR-M',
                                    'passZoomValuesToTarget': false,
                                    'autoZoom': false,
                                    'selectable': true
                                }]
                            },
                            'autoZoom': true,
                            'selectable': true
                        }]
                    },
                    'passZoomValuesToTarget': true,
                    'autoZoom': true
                },
                {
                    'id':'australia',
                    'linkToObject': {
                        'map': 'worldLow',
                        'getAreasFromMap': true
                    },
                    'passZoomValuesToTarget': true,
                    'autoZoom': true
                },
                {
                    'id':'africa',
                    'linkToObject': {
                        'map': 'worldLow',
                        'getAreasFromMap': true
                    },
                    'passZoomValuesToTarget': true,
                    'autoZoom': true
                }]
            },

            listeners: [{
                'event':'clickMapObject',
                'method': Ember.run.bind(this, 'clickMapObject')
            },
            {
                'event':'homeButtonClicked',
                'method': Ember.run.bind(this, 'homeButtonClicked')
            }]
        }));
    },

    clickMapObject: function(event) {
        this.get('filter').set('location', event.mapObject.title);
    },

    homeButtonClicked: function(event) {
        if(event.chart.dataProvider.map !== 'continentsLow') {
            this.createAmMap();
        }
    }

});
